/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.io.RAMStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO_fv2;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO_fv4;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public final class StatsProviderIO {
    public static final String FILE_EXTENSION = "mcbs";
    public static final int FILE_VERSION = 4;

    private StatsProviderIO() {
    }

    public static final void write(FriendlyByteBuf buffer, IStatsProvider statsProvider) throws NullPointerException {
        Objects.requireNonNull(statsProvider);
        Objects.requireNonNull(buffer);
        buffer.writeBytes("RIFF".getBytes(StandardCharsets.US_ASCII));
        StatsProviderIO.write_file(buffer, statsProvider, 4);
    }

    private static final void write_file(FriendlyByteBuf buffer, IStatsProvider statsProvider, int fileVersion) {
        if (fileVersion < 1) {
            throw new IllegalArgumentException("Attempting to write file version < 1.");
        }
        FriendlyByteBuf buffer_file = new FriendlyByteBuf(Unpooled.buffer());
        if (FILE_EXTENSION.length() != 4) {
            throw new IllegalStateException("Illegal file extension length, must be 4! Current value: mcbs");
        }
        buffer_file.writeBytes(FILE_EXTENSION.toUpperCase().getBytes(StandardCharsets.US_ASCII));
        buffer_file.writeIntLE(fileVersion);
        switch (fileVersion) {
            case 2: {
                StatsProviderIO_fv2.write_fileChunks(buffer_file, statsProvider);
                break;
            }
            case 4: {
                StatsProviderIO_fv4.write_fileChunks(buffer_file, statsProvider);
                break;
            }
        }
        buffer.writeIntLE(buffer_file.readableBytes());
        buffer.writeBytes((ByteBuf)buffer_file);
        buffer_file.release();
    }

    public static final void read(FriendlyByteBuf buffer, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        if (buffer.readableBytes() < 8) {
            throw new IllegalHeaderException("chunk size >= 8", "chunk size == " + buffer.readableBytes());
        }
        buffer.markReaderIndex();
        try {
            String RIFF = buffer.readSlice(4).toString(StandardCharsets.US_ASCII);
            if (!"RIFF".equalsIgnoreCase(RIFF)) {
                throw new IllegalHeaderException("RIFF", RIFF);
            }
            int fileLength = buffer.readIntLE();
            if (buffer.readableBytes() < fileLength) {
                throw new IllegalHeaderException("chunk size >= " + fileLength, "chunk size == " + buffer.readableBytes());
            }
            FriendlyByteBuf buffer_file = new FriendlyByteBuf(buffer.readSlice(fileLength));
            StatsProviderIO.read_file(buffer_file, statsProvider);
        }
        catch (IllegalHeaderException | UnsupportedFileVersionException exc) {
            buffer.resetReaderIndex();
            throw exc;
        }
    }

    private static final void read_file(FriendlyByteBuf buffer_file, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        String FEXT = buffer_file.readSlice(4).toString(StandardCharsets.US_ASCII);
        if (!FILE_EXTENSION.equalsIgnoreCase(FEXT)) {
            throw new IllegalHeaderException(FILE_EXTENSION, FEXT);
        }
        int fileVersion = buffer_file.readIntLE();
        switch (fileVersion) {
            case 2: {
                StatsProviderIO_fv2.read_fileChunks(buffer_file, statsProvider);
                break;
            }
            case 4: {
                StatsProviderIO_fv4.read_fileChunks(buffer_file, statsProvider);
                break;
            }
            default: {
                throw new UnsupportedFileVersionException(Integer.toString(fileVersion));
            }
        }
    }

    public static final void writeGameProfile(FriendlyByteBuf buffer, @Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            buffer.writeBoolean(false);
            buffer.writeBoolean(false);
            return;
        }
        UUID uuid = gameProfile.id();
        String name = gameProfile.name();
        if (uuid != null) {
            buffer.writeBoolean(true);
            buffer.writeUUID(uuid);
        } else {
            buffer.writeBoolean(false);
        }
        if (name != null) {
            buffer.writeBoolean(true);
            buffer.writeUtf(name);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Nullable
    public static final GameProfile readGameProfile(FriendlyByteBuf buffer) {
        String name;
        UUID uuid = buffer.readBoolean() ? buffer.readUUID() : null;
        String string = name = buffer.readBoolean() ? buffer.readUtf() : null;
        if (name == null && uuid == null) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static void saveToFile(File file, IStatsProvider statsProvider) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(statsProvider);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(file);
                 FileChannel fileChannel = fos.getChannel();){
                StatsProviderIO.write(buffer, statsProvider);
                while (buffer.isReadable()) {
                    buffer.readBytes((GatheringByteChannel)fileChannel, buffer.readableBytes());
                }
            }
        }
        catch (SecurityException se) {
            throw new IOException(se);
        }
        finally {
            buffer.release();
        }
    }

    public static IEditableStatsProvider loadFromFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        byte[] fileData = FileUtils.readFileToByteArray((File)file);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])fileData));
        return new RAMStatsProvider(buffer, true);
    }
}

