/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.api.util.io.RAMStatsProvider;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.QuickShareScreen;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.betterstats.util.io.BetterStatsWebApiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIListLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TStackTracePanel;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Axis2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.cache.IResourceFetchTask;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class QuickShareDownloadScreen
extends QuickShareScreen {
    @Nullable
    private Screen bssParent;
    private final String quickShareCode;
    @ApiStatus.Internal
    private volatile boolean __started = false;
    @ApiStatus.Internal
    private volatile int __stage = 0;
    @ApiStatus.Internal
    private volatile Throwable __error = null;

    public QuickShareDownloadScreen(@Nullable Screen bssParent, @Nullable Screen parent, String quickShareCode) throws NullPointerException {
        super(parent, (Component)BST.gui_qsscreen_download_title());
        this.bssParent = bssParent;
        Objects.requireNonNull(quickShareCode);
        quickShareCode = ((String)quickShareCode).toLowerCase(Locale.ENGLISH);
        if (!((String)quickShareCode).endsWith(QSC_SUFFIX)) {
            quickShareCode = (String)quickShareCode + QSC_SUFFIX;
        }
        this.quickShareCode = quickShareCode;
    }

    protected final void init() {
        this.__start__stage1and2and3();
        TLabelElement lbl = new TLabelElement(0, 0, this.getWidth(), this.getHeight());
        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        lbl.setTextColor(-256);
        this.addChild((TElement)lbl, false);
        switch (this.__stage) {
            case -1: {
                this.removeChild((TElement)lbl, false);
                int w = (int)((float)this.getWidth() * 0.6f);
                if (w < 300) {
                    w = 300;
                }
                if (w > this.getWidth()) {
                    w = this.getWidth();
                }
                TStackTracePanel panel_st = new TStackTracePanel(0, 0, w, this.getHeight() - 50, this.__error);
                panel_st.setCloseAction(() -> this.close());
                panel_st.setTitle(BST.gui_qsscreen_download_stageN1().getString());
                panel_st.setDescription(this.__error.getMessage());
                this.addChild((TElement)panel_st, false);
                new UIListLayout(Axis2D.Y, VerticalAlignment.CENTER, HorizontalAlignment.CENTER).apply((TParentElement)this);
                break;
            }
            case 0: {
                lbl.setText((Component)BST.gui_qsscreen_download_stage0());
                break;
            }
            case 1: {
                lbl.setText((Component)BST.gui_qsscreen_download_stage1());
                break;
            }
            case 2: {
                lbl.setText((Component)BST.gui_qsscreen_download_stage2());
                break;
            }
            case 3: {
                lbl.setText((Component)BST.gui_qsscreen_download_stage3());
                break;
            }
            case 4: {
                lbl.setText((Component)BST.gui_qsscreen_download_stage4());
                break;
            }
        }
    }

    @ApiStatus.Internal
    private void __start_onError(@Nullable Exception exception) {
        this.__stage = -1;
        this.__error = exception;
        if (!this.isOpen()) {
            return;
        }
        this.refresh();
        BetterStats.LOGGER.error("[Quick-Share] Failed to download quick-shared statistics using the code; " + this.quickShareCode, (Throwable)exception);
    }

    @ApiStatus.Internal
    private void __start__stage1and2and3() {
        if (this.__started) {
            return;
        }
        this.__started = true;
        this.__stage = 1;
        if (!this.isOpen()) {
            return;
        }
        BetterStats.LOGGER.info("[Quick-Share] Downloading quick-shared statistics using the code; " + this.quickShareCode);
        @Nullable ResourceLocation mcbsCachedId = null;
        try {
            mcbsCachedId = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)("quick_share/downloads/" + this.quickShareCode));
        }
        catch (Exception e) {
            this.__start_onError(e);
            return;
        }
        CachedResourceManager.getResourceAsync((ResourceLocation)mcbsCachedId, (IResourceFetchTask)new IResourceFetchTask<byte[]>(){

            public final BlockableEventLoop<?> getMinecraftClientOrServer() {
                return BetterStatsClient.MC_CLIENT;
            }

            public final Class<byte[]> getResourceType() {
                return byte[].class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final CachedResource<byte[]> fetchResourceSync() throws Exception {
                CachedResource cachedResource;
                block16: {
                    final AtomicReference au_ready = new AtomicReference();
                    AtomicReference au_error = new AtomicReference();
                    BetterStatsWebApiUtils.fetchBssApiLinks(false, BetterStatsClient.MC_CLIENT, json -> au_ready.set(json), error -> au_error.set(error));
                    if (au_error.get() != null) {
                        Object v = au_error.get();
                        if (v instanceof HttpResponseException) {
                            HttpResponseException hre = (HttpResponseException)v;
                            String msg = "HTTP " + hre.getStatusCode() + " " + hre.getReasonPhrase();
                            String txt = BST.gui_qsscreen_err_cmmn_fau_httpN200(msg).getString();
                            throw new IOException(txt, (Throwable)au_error.get());
                        }
                        String txt = BST.gui_qsscreen_err_cmmn_fau_generic().getString();
                        throw new IOException(txt, (Throwable)au_error.get());
                    }
                    if (au_ready.get() == null) {
                        throw new NullPointerException("This shouldn't happen.");
                    }
                    QuickShareDownloadScreen.this.__stage = 2;
                    if (!QuickShareDownloadScreen.this.isOpen()) {
                        throw new RuntimeException("Aborted.");
                    }
                    QuickShareDownloadScreen.this.refresh();
                    final AtomicReference du_ready = new AtomicReference();
                    final AtomicReference du_error = new AtomicReference();
                    CachedResourceManager.getResourceSync((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)("quick_share/download_urls/" + QuickShareDownloadScreen.this.quickShareCode + ".json")), (IResourceFetchTask)new IResourceFetchTask<JsonObject>(){

                        public final BlockableEventLoop<?> getMinecraftClientOrServer() {
                            return BetterStatsClient.MC_CLIENT;
                        }

                        public final Class<JsonObject> getResourceType() {
                            return JsonObject.class;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final CachedResource<JsonObject> fetchResourceSync() throws Exception {
                            CachedResource cachedResource;
                            block10: {
                                JsonObject links = (JsonObject)au_ready.get();
                                @Nullable CloseableHttpResponse response = null;
                                try {
                                    String endpoint = null;
                                    try {
                                        endpoint = links.get("quickshare_gdu").getAsString();
                                    }
                                    catch (Exception exc) {
                                        String additionalNote = "-";
                                        if (links.has("quickshare_notice") && links.get("quickshare_notice").isJsonPrimitive()) {
                                            additionalNote = links.get("quickshare_notice").getAsString();
                                        }
                                        throw new IOException(BST.gui_qsscreen_err_cmmn_fau_mssngUrl(additionalNote).getString(), exc);
                                    }
                                    response = HttpUtils.fetchSync((String)endpoint, (HttpUtils.FetchOptions)new HttpUtils.FetchOptions(){

                                        public final String method() {
                                            return "POST";
                                        }

                                        public final Object body() {
                                            JsonObject bodyJson = new JsonObject();
                                            QuickShareScreen.addTelemetryData(bodyJson);
                                            bodyJson.addProperty("file", QuickShareDownloadScreen.this.quickShareCode);
                                            return bodyJson;
                                        }
                                    });
                                    String responseMessage = "";
                                    if (response.getEntity() != null) {
                                        responseMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                                    }
                                    int statusCode = response.getStatusLine().getStatusCode();
                                    String statusMessage = response.getStatusLine().getReasonPhrase();
                                    if (statusCode != 200) {
                                        throw new IOException(BST.gui_qsscreen_err_dwnl_gdu_httpN200("HTTP " + statusCode + " " + statusMessage + "\n" + responseMessage).getString(), (Throwable)new HttpResponseException(statusCode, statusMessage));
                                    }
                                    JsonObject json = (JsonObject)BetterStatsWebApiUtils.GSON.fromJson(responseMessage, JsonObject.class);
                                    Instant expires = null;
                                    try {
                                        expires = Instant.parse(json.get("expires").getAsString());
                                    }
                                    catch (Exception parseExc) {
                                        expires = Instant.now().plusSeconds(30L);
                                    }
                                    cachedResource = new CachedResource((Object)json, (long)responseMessage.length(), expires);
                                    if (response == null) break block10;
                                }
                                catch (Throwable throwable) {
                                    if (response != null) {
                                        IOUtils.closeQuietly(response);
                                    }
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((Closeable)response);
                            }
                            return cachedResource;
                        }

                        public final void onError(Exception error) {
                            du_error.set(error);
                        }

                        public final void onReady(JsonObject result) {
                            du_ready.set(result);
                        }
                    });
                    if (du_error.get() != null) {
                        throw (Exception)du_error.get();
                    }
                    if (du_ready.get() == null) {
                        throw new NullPointerException("This shouldn't happen.");
                    }
                    QuickShareDownloadScreen.this.__stage = 3;
                    if (!QuickShareDownloadScreen.this.isOpen()) {
                        throw new RuntimeException("Aborted.");
                    }
                    QuickShareDownloadScreen.this.refresh();
                    JsonObject downloadUrlData = (JsonObject)du_ready.get();
                    String url = downloadUrlData.get("url").getAsString();
                    final String method = downloadUrlData.get("method").getAsString().toUpperCase(Locale.ENGLISH);
                    final BasicHeader[] headers = (BasicHeader[])downloadUrlData.get("headers").getAsJsonObject().entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString())).toArray(BasicHeader[]::new);
                    if (!Objects.equals(method, "GET")) {
                        throw new UnsupportedOperationException("BSS API server told me to perform HTTP " + method + " to download the quick-share file, but I only support HTTP GET.");
                    }
                    CloseableHttpResponse response = null;
                    try {
                        byte[] responseBody;
                        response = HttpUtils.fetchSync((String)url, (HttpUtils.FetchOptions)new HttpUtils.FetchOptions(){

                            public final String method() {
                                return method;
                            }

                            public final Header[] headers() {
                                return headers;
                            }
                        });
                        int statusCode = response.getStatusLine().getStatusCode();
                        String statusMessage = response.getStatusLine().getReasonPhrase();
                        if (statusCode != 200) {
                            @Nullable String responseBody2 = "";
                            if (response.getEntity() != null) {
                                responseBody2 = EntityUtils.toString((HttpEntity)response.getEntity());
                            }
                            throw new IOException(BST.gui_qsscreen_err_dwnl_act_httpN200("HTTP " + statusCode + " " + statusMessage + "\n" + responseBody2).getString(), (Throwable)new HttpResponseException(statusCode, statusMessage));
                        }
                        byte[] byArray = responseBody = response.getEntity() != null ? EntityUtils.toByteArray((HttpEntity)response.getEntity()) : null;
                        if (responseBody == null) {
                            throw new IOException("Cloud server responded with an empty file with no data inside of it.");
                        }
                        Instant expires_file = null;
                        try {
                            expires_file = Instant.parse(downloadUrlData.get("expires_file").getAsString());
                        }
                        catch (Exception parseExc) {
                            expires_file = Instant.now().plus(Duration.ofDays(1L));
                        }
                        cachedResource = new CachedResource((Object)responseBody, (long)responseBody.length, expires_file);
                        if (response == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            IOUtils.closeQuietly(response);
                        }
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)response);
                }
                return cachedResource;
            }

            public final void onError(Exception error) {
                QuickShareDownloadScreen.this.__start_onError(error);
            }

            public final void onReady(byte[] result) {
                QuickShareDownloadScreen.this.__start__stage4(result);
            }
        });
    }

    @ApiStatus.Internal
    private void __start__stage4(byte[] mcbs) {
        this.__stage = 4;
        if (!this.isOpen()) {
            return;
        }
        this.refresh();
        try {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])mcbs));
            RAMStatsProvider stats = new RAMStatsProvider(buffer, true);
            BetterStatsScreen bss = new BetterStatsScreen(this.bssParent, stats);
            BetterStatsClient.MC_CLIENT.setScreen(bss.getAsScreen());
            BetterStats.LOGGER.info("[Quick-Share] Succesfully downloaded quick-shared statistics using the code; " + this.quickShareCode);
        }
        catch (Exception exc) {
            this.__start_onError(exc);
        }
    }
}

