/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenPlus;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfoProvider;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

abstract class QuickShareScreen
extends TScreenPlus
implements IParentScreenProvider {
    protected static final String QSC_SUFFIX = ".mcbs".toLowerCase(Locale.ENGLISH);
    @Nullable
    private Screen parent;

    public QuickShareScreen(@Nullable Screen parent, Component title) {
        super(title);
        this.parent = parent;
    }

    public final Screen getParentScreen() {
        return this.parent;
    }

    @Virtual
    public void close() {
        BetterStatsClient.MC_CLIENT.setScreen(this.getParentScreen());
    }

    protected final void refresh() {
        BetterStatsClient.MC_CLIENT.executeIfPossible(() -> {
            if (!this.isOpen()) {
                return;
            }
            this.clearChildren();
            this.init();
        });
    }

    @Virtual
    public void renderBackground(TDrawContext pencil) {
        super.renderBackground(pencil);
        pencil.drawTFill(0x50000000);
    }

    @ApiStatus.Internal
    protected static final void addTelemetryData(JsonObject httpRequestBody) {
        ModInfoProvider mi = Objects.requireNonNull(ModInfoProvider.getInstance());
        ModInfo miMinecraft = mi.getModInfo("minecraft");
        ModInfo miBetterStats = mi.getModInfo(BetterStats.getModID());
        httpRequestBody.addProperty("mod_info.minecraft.version", miMinecraft.getVersion());
        httpRequestBody.addProperty("mod_info.betterstats.version", miBetterStats.getVersion());
        User session = BetterStatsClient.MC_CLIENT.getUser();
        UUID session_uuid = Optional.ofNullable(session.getProfileId()).orElse(new UUID(0L, 0L));
        httpRequestBody.addProperty("session.username", session.getName());
        httpRequestBody.addProperty("session.uuid", session_uuid.toString());
        httpRequestBody.addProperty("session.account_type", "unknown");
        httpRequestBody.add("device.net.mac_address", QuickShareScreen.getNicMacAddr());
    }

    @ApiStatus.Internal
    private static final JsonElement getNicMacAddr() {
        try {
            Socket socket = new Socket("example.com", 443);
            InetAddress localAddr = socket.getLocalAddress();
            socket.close();
            NetworkInterface netInt = Objects.requireNonNull(NetworkInterface.getByInetAddress(localAddr));
            byte[] netAddr = Objects.requireNonNull(netInt.getHardwareAddress());
            JsonArray netAddrJson = new JsonArray();
            IntStream.range(0, netAddr.length).map(i -> netAddr[i]).forEach(i -> netAddrJson.add((Number)i));
            return netAddrJson;
        }
        catch (Exception e) {
            return JsonNull.INSTANCE;
        }
    }
}

