/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.BSStatsTabs;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.BetterStatsPanel;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.awt.Rectangle;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class BSConfigTab
extends StatsTab {
    public static final Component TEXT_TITLE = TextUtils.translatable((String)"options.title", (Object[])new Object[0]);
    @Nullable
    private TConfigPanelBuilder<?> config_builder;

    @Override
    public final Component getName() {
        return TEXT_TITLE;
    }

    @Override
    public final boolean isAvailable() {
        return false;
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        this.config_builder = BSConfigTab.initConfigGui(initContext.getStatsPanel());
    }

    @Override
    public final void initFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initDefaultFilters(initContext);
        TPanelElement panel = initContext.getFiltersPanel();
        StatsTabUtils.initGroupLabel(panel, TEXT_TITLE);
        Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
        n1.y += 3;
        TButtonWidget btn_done = new TButtonWidget(n1.x, n1.y, n1.width, 20, (Component)TextUtils.translatable((String)"gui.done", (Object[])new Object[0]));
        btn_done.setOnClick(__ -> {
            if (this.config_builder == null) {
                return;
            }
            this.config_builder.saveChanges();
            initContext.setSelectedStatsTab(BSStatsTabs.GENERAL);
            BetterStatsPanel bsp = (BetterStatsPanel)panel.findParent(p -> p instanceof BetterStatsPanel);
            if (bsp != null) {
                bsp.refresh();
            }
        });
        panel.addChild((TElement)btn_done, false);
        Rectangle n2 = UILayout.nextChildVerticalRect((TParentElement)panel);
        n2.y += 3;
        TButtonWidget btn_cancel = new TButtonWidget(n2.x, n2.y, n2.width, 20, (Component)TextUtils.translatable((String)"gui.cancel", (Object[])new Object[0]));
        btn_cancel.setOnClick(__ -> initContext.setSelectedStatsTab(BSStatsTabs.GENERAL));
        panel.addChild((TElement)btn_cancel, false);
    }

    public static final TConfigPanelBuilder<?> initConfigGui(TPanelElement panel) {
        BetterStatsConfig config = BetterStats.getInstance().getConfig();
        TConfigPanelBuilder configBuilder = TConfigPanelBuilder.builder((TPanelElement)panel);
        BSConfigTab.initConfigGui_debug(config, configBuilder);
        BSConfigTab.initConfigGui_clientSide(config, configBuilder);
        BSConfigTab.initConfigGui_serverSide(config, configBuilder);
        configBuilder.build(() -> {
            try {
                config.saveToFile(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save mod config.", e);
            }
        });
        return configBuilder;
    }

    private static final void initConfigGui_debug(BetterStatsConfig config, TConfigPanelBuilder<?> configBuilder) {
        configBuilder.addCheckbox((Component)BST.config_debugMode(), BetterStatsConfig.DEBUG_MODE, checkbox -> {
            BetterStatsConfig.DEBUG_MODE = checkbox.getChecked();
        });
    }

    private static final void initConfigGui_clientSide(BetterStatsConfig config, TConfigPanelBuilder<?> configBuilder) {
        configBuilder.addLabelB((Component)TCDCT.tcdc_term_clientSide()).setTextColor(-256);
        configBuilder.addCheckbox((Component)BST.config_guiSmoothScroll(), config.guiSmoothScroll, checkbox -> {
            config.guiSmoothScroll = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_guiSmoothScroll_tooltip()));
        configBuilder.addCheckbox((Component)BST.config_guiMobsFollowCursor(), config.guiMobsFollowCursor, checkbox -> {
            config.guiMobsFollowCursor = checkbox.getChecked();
        });
        configBuilder.addCheckbox((Component)BST.config_trustAllServersBssNet(), config.trustAllServersBssNet, checkbox -> {
            config.trustAllServersBssNet = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_trustAllServersBssNet_tooltip()));
        configBuilder.addCheckbox((Component)BST.config_allowStatsSharing(), config.netPref_allowStatsSharing, checkbox -> {
            config.netPref_allowStatsSharing = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_allowStatsSharing_tooltip()));
        configBuilder.addCheckbox((Component)BST.config_wideStatsPanel(), config.wideStatsPanel, checkbox -> {
            config.wideStatsPanel = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_wideStatsPanel_tooltip()));
        configBuilder.addCheckbox((Component)BST.config_centeredStatsPanel(), config.centeredStatsPanel, checkbox -> {
            config.centeredStatsPanel = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_centeredStatsPanel_tooltip()));
        configBuilder.addCheckbox((Component)BST.config_updDspCtxOnJoin(), config.updateItemGroupsOnJoin, checkbox -> {
            config.updateItemGroupsOnJoin = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_updDspCtxOnJoin_tooltip()));
        configBuilder.addCheckbox((Component)BST.config_hidePlayerInfo(), config.hidePlayerInfo, checkbox -> {
            config.hidePlayerInfo = checkbox.getChecked();
        });
        configBuilder.getLastAddedElement().setTooltip(Tooltip.create((Component)BST.config_hidePlayerInfo_tooltip()));
    }

    private static final void initConfigGui_serverSide(BetterStatsConfig config, TConfigPanelBuilder<?> configBuilder) {
        configBuilder.addLabelB((Component)TCDCT.tcdc_term_serverSide()).setTextColor(-256);
        configBuilder.addCheckbox((Component)BST.config_registerCommands(), config.registerCommands, checkbox -> {
            config.registerCommands = checkbox.getChecked();
        });
        configBuilder.addCheckbox((Component)BST.config_enableSas(), config.enableServerSAS, checkbox -> {
            config.enableServerSAS = checkbox.getChecked();
        });
    }
}

