/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.stats.panel.StatsSummaryPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.MobStatTextWidget;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.MobStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortMobsBy;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui.screen.hud.entry.StatsHudMobEntry;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.BSStatsTab;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobCategory;
import org.jetbrains.annotations.ApiStatus;

@Virtual
@ApiStatus.Internal
public class MobStatsTab
extends BSStatsTab<SUMobStat> {
    private static final int ITEMS_PER_PAGE = 125;
    private static final boolean IS_VISUAL = false;

    @Override
    @Virtual
    public Component getName() {
        return TextUtils.translatable((String)"stat.mobsButton", (Object[])new Object[0]);
    }

    @Override
    @Virtual
    public void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        IStatsProvider stats = initContext.getStatsProvider();
        StatFilterSettings filters = initContext.getFilterSettings();
        FilterGroupBy filter_group = (FilterGroupBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_GROUP, (Object)FilterGroupBy.DEFAULT));
        FilterSortMobsBy filter_sort = (FilterSortMobsBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SORT_MOBS, (Object)FilterSortMobsBy.DEFAULT));
        List<SUMobStat> mobStats = SUMobStat.getMobStats(stats, this.getPredicate(filters));
        int mobStatsSize = mobStats.size();
        filter_sort.sortMobStats(mobStats);
        if (mobStatsSize > 0) {
            this.initPageChooser(initContext, mobStatsSize, 125);
            int maxPages = Math.max((int)Math.ceil((double)mobStatsSize / 125.0), 1);
            int page = Math.min(this.getPageFilter(filters).get(), maxPages);
            int from = Math.max(page - 1, 0) * 125;
            int to = Math.max(Math.min(page * 125, mobStatsSize), from);
            List subl = TUtils.safeSubList(mobStats, (int)from, (int)to);
            Map statGroups = filter_group == FilterGroupBy.DEFAULT ? this.getDefaultGroupFilter().apply(subl, new SUMobStat[0]) : filter_group.apply(subl, new SUMobStat[0]);
            for (Map.Entry statGroup : statGroups.entrySet()) {
                Component group = (Component)statGroup.getKey();
                StatsTabUtils.initGroupLabel(panel, (Component)(group != null ? group : TextUtils.literal((String)"*")));
                MobStatsTab.initStats(panel, (Collection)statGroup.getValue(), widget -> this.processWidget((MobStatWidget)((Object)widget)));
            }
            StatsSummaryPanel summary = MobStatsTab.initStatsSummary(panel);
            summary.summarizeMobStats(mobStats);
            summary.autoHeight();
            this.initPageChooser(initContext, mobStatsSize, 125);
        }
    }

    @Override
    @Virtual
    protected void initExtraFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initGroupByFilter(initContext);
        StatsTabUtils.initSortMobsByFilter(initContext);
    }

    @Override
    @Virtual
    protected Predicate<SUMobStat> getPredicate(StatFilterSettings filterSettings) {
        return super.getPredicate(filterSettings).and(stat -> stat.getEntityType().getCategory() != MobCategory.MISC || !stat.isEmpty());
    }

    @Virtual
    protected FilterGroupBy getDefaultGroupFilter() {
        return FilterGroupBy.DEFAULT;
    }

    protected static void initStats(TPanelElement panel, Collection<SUMobStat> stats, Consumer<MobStatWidget> processWidget) {
        int wmp = panel.getWidth() - panel.getScrollPadding() * 2;
        int nextX = panel.getScrollPadding();
        int nextY = UILayout.nextChildBottomY((TParentElement)panel) - panel.getY();
        for (SUMobStat stat : stats) {
            MobStatTextWidget statElement = new MobStatTextWidget(nextX, nextY, panel.getWidth() - panel.getScrollPadding() * 2, stat);
            panel.addChild((TElement)statElement, true);
            nextY = UILayout.nextChildBottomY((TParentElement)panel) - panel.getY() + 3;
        }
    }

    @Virtual
    protected void processWidget(MobStatWidget widget) {
        widget.eContextMenu.register((__, cMenu) -> {
            if (!(((SUMobStat)widget.getStat()).getStatsProvider() instanceof LocalPlayerStatsProvider)) {
                return;
            }
            cMenu.addButton((Component)BST.hud_pinStat(), ___ -> {
                BetterStatsHudScreen hud = BetterStatsHudScreen.getInstance();
                hud.setParentScreen(BetterStatsClient.MC_CLIENT.screen);
                hud.addEntry(new StatsHudMobEntry((SUMobStat)widget.getStat()));
                BetterStatsClient.MC_CLIENT.setScreen(hud.getAsScreen());
            });
            cMenu.addButton((Component)TextUtils.translatable((String)"mco.selectServer.close", (Object[])new Object[0]), ___ -> {});
        });
    }
}

