/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TClickableWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class AdvancementStatWidget
extends TClickableWidget {
    private final AdvancementNode advancement;
    private final ItemStack displayItem;
    private int backgroundColor = 0;
    @Nullable
    private Consumer<AdvancementStatWidget> onClick;

    public AdvancementStatWidget(int x, int y, AdvancementNode advancement) throws NullPointerException {
        super(x, y, 21, 21);
        this.advancement = Objects.requireNonNull(advancement);
        MutableComponent tooltip = TextUtils.literal((String)"");
        DisplayInfo display = advancement.advancement().display().orElse(null);
        if (display != null) {
            tooltip.append((Component)TextUtils.literal((String)"").append(display.getTitle()).withStyle(ChatFormatting.YELLOW));
            tooltip.append("\n");
            tooltip.append((Component)TextUtils.literal((String)"").append(display.getDescription()).withStyle(ChatFormatting.GRAY));
            this.displayItem = display.getIcon();
            this.backgroundColor = switch (display.getType()) {
                case AdvancementType.TASK -> 0x50000000;
                case AdvancementType.GOAL -> 1344418611;
                case AdvancementType.CHALLENGE -> 1144193126;
                default -> 0x50000000;
            };
        } else {
            tooltip.append((Component)TextUtils.literal((String)advancement.holder().id().toString()).withStyle(ChatFormatting.YELLOW));
            this.displayItem = Items.AIR.getDefaultInstance();
            this.backgroundColor = 0x50000000;
        }
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    @Nullable
    public final Consumer<AdvancementStatWidget> getOnClick() {
        return this.onClick;
    }

    public final void setOnClick(@Nullable Consumer<AdvancementStatWidget> onClick) {
        this.onClick = onClick;
    }

    public final AdvancementNode getAdvancement() {
        return this.advancement;
    }

    protected final void onClick() {
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
    }

    public final void render(TDrawContext pencil) {
        pencil.drawTFill(this.backgroundColor);
        pencil.renderItem(this.displayItem, this.getX() + 3, this.getY() + 3);
    }

    public final void postRender(TDrawContext pencil) {
        if (this.isFocusedOrHovered()) {
            pencil.drawTBorder(-5570561);
        }
    }
}

