/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.command.PlayerBadgeCommand;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorStatHandler;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class StatisticsCommand {
    public static final Component TEXT_CLEAR_KICK = BST.cmd_stats_clear_kick();
    private static SuggestionProvider<CommandSourceStack> SUGGEST_STAT = (context, builder) -> {
        @Nullable StatType statType = null;
        try {
            statType = (StatType)ResourceArgument.getResource((CommandContext)context, (String)"stat_type", (ResourceKey)Registries.STAT_TYPE).value();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (statType == null) {
            return ResourceLocationArgument.id().listSuggestions(context, builder);
        }
        @Nullable List<ResourceLocation> suggestions = statType.getRegistry().registryKeySet().stream().map(ResourceKey::location).toList();
        return SharedSuggestionProvider.suggest(StreamSupport.stream(suggestions.spliterator(), false).map(Objects::toString), (SuggestionsBuilder)builder);
    };

    private StatisticsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext cra) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"statistics").requires(scs -> scs.hasPermission(2))).then(StatisticsCommand.statistics_edit(cra))).then(StatisticsCommand.statistics_clear())).then(StatisticsCommand.statistics_query(cra))).then(StatisticsCommand.statistics_populateAll(cra));
        LiteralArgumentBuilder stats = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stats").requires(scs -> scs.hasPermission(2))).then(StatisticsCommand.statistics_edit(cra))).then(StatisticsCommand.statistics_clear())).then(StatisticsCommand.statistics_query(cra))).then(StatisticsCommand.statistics_populateAll(cra));
        dispatcher.register(statistics);
        dispatcher.register(stats);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> statistics_edit(CommandBuildContext cra) {
        return Commands.literal((String)"edit").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"stat_type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)cra, (ResourceKey)Registries.STAT_TYPE)).then(((RequiredArgumentBuilder)Commands.argument((String)"stat", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_STAT).then(Commands.literal((String)"set").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StatisticsCommand.execute_edit((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.literal((String)"increase").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> StatisticsCommand.execute_edit((CommandContext<CommandSourceStack>)ctx, false)))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> statistics_clear() {
        return Commands.literal((String)"clear").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> StatisticsCommand.execute_clear((CommandContext<CommandSourceStack>)ctx)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> statistics_query(CommandBuildContext cra) {
        return Commands.literal((String)"query").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"stat_type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)cra, (ResourceKey)Registries.STAT_TYPE)).then(Commands.argument((String)"stat", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_STAT).executes(ctx -> StatisticsCommand.execute_query((CommandContext<CommandSourceStack>)ctx)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> statistics_populateAll(CommandBuildContext cra) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"danger_zone_populate_all_stats").requires(scs -> BetterStatsConfig.DEBUG_MODE)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> StatisticsCommand.execute_populateAll((CommandContext<CommandSourceStack>)ctx)));
    }

    private static int execute_edit(CommandContext<CommandSourceStack> context, boolean setOrIncrease) {
        try {
            Collection arg_targets = EntityArgument.getPlayers(context, (String)"targets");
            StatType arg_stat_type = (StatType)ResourceArgument.getResource(context, (String)"stat_type", (ResourceKey)Registries.STAT_TYPE).value();
            ResourceLocation arg_stat = ResourceLocationArgument.getId(context, (String)"stat");
            int arg_value = IntegerArgumentType.getInteger(context, (String)"value");
            Object stat_object = arg_stat_type.getRegistry().getOptional(arg_stat).orElse(null);
            Objects.requireNonNull(stat_object, "Registry entry '" + String.valueOf(arg_stat) + "' does not exist for registry '" + String.valueOf(arg_stat_type.getRegistry()) + "'.");
            Stat stat = arg_stat_type.get(stat_object);
            AtomicInteger affected = new AtomicInteger();
            for (ServerPlayer target : arg_targets) {
                if (target == null) continue;
                if (setOrIncrease) {
                    target.getStats().setValue((Player)target, stat, arg_value);
                } else {
                    target.getStats().increment((Player)target, stat, arg_value);
                }
                affected.incrementAndGet();
                target.getStats().sendStats(target);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> BST.cmd_stats_edit_out((Component)TextUtils.literal((String)("[" + String.valueOf(BuiltInRegistries.STAT_TYPE.getKey((Object)arg_stat_type)) + " / " + String.valueOf(arg_stat) + "]")), (Component)TextUtils.literal((String)Integer.toString(affected.get()))), false);
            return affected.get();
        }
        catch (CommandSyntaxException | IllegalStateException | NullPointerException e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }

    private static int execute_clear(CommandContext<CommandSourceStack> context) {
        try {
            Collection targets = EntityArgument.getPlayers(context, (String)"targets");
            AtomicInteger affected = new AtomicInteger();
            for (ServerPlayer target : targets) {
                if (target == null) continue;
                ((AccessorStatHandler)target.getStats()).getStatMap().clear();
                affected.incrementAndGet();
                target.connection.disconnect((Component)TextUtils.literal((String)"").append(TEXT_CLEAR_KICK).append("\n\n[EN]: Your statistics were cleared, which requires you to disconnect and re-join."));
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> BST.cmd_stats_clear_out((Component)TextUtils.literal((String)Integer.toString(affected.get()))), false);
            return affected.get();
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }

    private static int execute_query(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer arg_target = EntityArgument.getPlayer(context, (String)"target");
            if (arg_target == null) {
                throw new SimpleCommandExceptionType((Message)TextUtils.literal((String)"Player not found.")).create();
            }
            StatType arg_stat_type = (StatType)ResourceArgument.getResource(context, (String)"stat_type", (ResourceKey)Registries.STAT_TYPE).value();
            ResourceLocation arg_stat = ResourceLocationArgument.getId(context, (String)"stat");
            Object stat_object = arg_stat_type.getRegistry().getOptional(arg_stat).orElse(null);
            Objects.requireNonNull(stat_object, "Registry entry '" + String.valueOf(arg_stat) + "' does not exist for registry '" + String.valueOf(arg_stat_type.getRegistry()) + "'.");
            Stat stat = arg_stat_type.get(stat_object);
            int statValue = arg_target.getStats().getValue(stat);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> BST.cmd_stats_query_out(arg_target.getDisplayName(), (Component)TextUtils.literal((String)("[" + String.valueOf(BuiltInRegistries.STAT_TYPE.getKey((Object)arg_stat_type)) + " / " + String.valueOf(arg_stat) + "]")), (Component)TextUtils.literal((String)Integer.toString(statValue))), false);
            return statValue;
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }

    private static int execute_populateAll(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer arg_target = EntityArgument.getPlayer(context, (String)"target");
            if (arg_target == null) {
                throw new SimpleCommandExceptionType((Message)TextUtils.literal((String)"Player not found.")).create();
            }
            int affected = 0;
            ServerStatsCounter sp = arg_target.getStats();
            for (StatType statType : BuiltInRegistries.STAT_TYPE) {
                for (Object stat : statType.getRegistry()) {
                    Stat s = statType.get(stat);
                    if (sp.getValue(s) != 0) continue;
                    sp.setValue((Player)arg_target, s, 1);
                    ++affected;
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextUtils.translatable((String)"gui.done", (Object[])new Object[0]), false);
            return affected;
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, (Throwable)e);
            return -1;
        }
    }
}

