/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3448;
import net.minecraft.class_7923;

public class StatsProviderIO_fv4 {
    static final void write_fileChunks(class_2540 buffer_file, IStatsProvider statsProvider) {
        StatsProviderIO_fv4.write_fileChunk("metadata", buffer_file, statsProvider);
        StatsProviderIO_fv4.write_fileChunk("stats", buffer_file, statsProvider);
        StatsProviderIO_fv4.write_fileChunk("tcdcommons:player_badges", buffer_file, statsProvider);
    }

    private static final void write_fileChunk(String chunkId, class_2540 buffer_file, IStatsProvider statsProvider) {
        class_2540 buffer_chunk = new class_2540(Unpooled.buffer());
        buffer_chunk.method_10814(chunkId);
        switch (chunkId) {
            case "metadata": {
                StatsProviderIO_fv4.write_fileChunk_metadata(buffer_chunk, statsProvider);
                break;
            }
            case "stats": {
                StatsProviderIO_fv4.write_fileChunk_stats(buffer_chunk, statsProvider);
                break;
            }
            case "tcdcommons:player_badges": {
                StatsProviderIO_fv4.write_fileChunk_playerBadges(buffer_chunk, statsProvider);
                break;
            }
        }
        buffer_file.method_53003(buffer_chunk.readableBytes());
        buffer_file.method_52975((ByteBuf)buffer_chunk);
        buffer_chunk.release();
    }

    private static final void write_fileChunk_metadata(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        class_2561 statsNameText = statsProvider.getDisplayName();
        String statsName = statsNameText != null ? statsNameText.getString() : "-";
        buffer_chunk.method_10814(statsName);
        StatsProviderIO.writeGameProfile(buffer_chunk, statsProvider.getGameProfile());
    }

    private static final void write_fileChunk_stats(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        for (class_3448 statType : class_7923.field_41193) {
            class_2540 buffer_st = new class_2540(Unpooled.buffer());
            buffer_st.method_10814(Objects.toString(class_7923.field_41193.method_10221((Object)statType)));
            StatsProviderIO_fv4.write_fileChunk_stats_statType(buffer_st, statsProvider, (class_3448<Object>)statType);
            buffer_chunk.method_53003(buffer_st.readableBytes());
            buffer_chunk.method_52975((ByteBuf)buffer_st);
            buffer_st.release();
        }
    }

    private static final void write_fileChunk_stats_statType(class_2540 buffer_st, IStatsProvider statsProvider, class_3448<Object> statType) {
        class_2378 registry = statType.method_14959();
        for (Object registryItem : registry) {
            int statValue = statsProvider.getStatValue(statType, registryItem);
            if (statValue == 0) continue;
            class_2960 registryItemId = registry.method_10221(registryItem);
            buffer_st.method_10814(registryItemId.method_12836().equals("minecraft") ? registryItemId.method_12832() : Objects.toString(registryItemId));
            buffer_st.method_53003(statValue);
        }
    }

    private static final void write_fileChunk_playerBadges(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUPlayerBadgeStat>> stats = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUPlayerBadgeStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUPlayerBadgeStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.value);
            }
        }
    }

    static final void read_fileChunks(class_2540 buffer_file, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        while (buffer_file.readableBytes() > 0) {
            String chunkId;
            int chunkSize = buffer_file.readIntLE();
            if (buffer_file.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_file.readableBytes());
            }
            class_2540 buffer_chunk = new class_2540(buffer_file.readSlice(chunkSize));
            switch (chunkId = buffer_chunk.method_19772()) {
                case "metadata": {
                    StatsProviderIO_fv4.read_fileChunk_metadata(buffer_chunk, statsProvider);
                    break;
                }
                case "stats": {
                    StatsProviderIO_fv4.read_fileChunk_stats(buffer_chunk, statsProvider);
                    break;
                }
                case "tcdcommons:player_badges": {
                    StatsProviderIO_fv4.read_fileChunk_playerBadges(buffer_chunk, statsProvider);
                    break;
                }
            }
        }
    }

    private static final void read_fileChunk_metadata(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        statsProvider.setDisplayName((class_2561)TextUtils.literal((String)buffer_chunk.method_19772()));
        statsProvider.setGameProfile(StatsProviderIO.readGameProfile(buffer_chunk));
    }

    private static final void read_fileChunk_stats(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) throws IllegalHeaderException {
        while (buffer_chunk.readableBytes() > 0) {
            int chunkSize = buffer_chunk.readIntLE();
            if (buffer_chunk.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_chunk.readableBytes());
            }
            class_2540 buffer_st = new class_2540(buffer_chunk.readSlice(chunkSize));
            StatsProviderIO_fv4.read_fileChunk_stats_statType(buffer_st, statsProvider);
        }
    }

    private static final void read_fileChunk_stats_statType(class_2540 buffer_st, IEditableStatsProvider statsProvider) {
        class_3448 statType;
        class_2960 statTypeId = class_2960.method_60654((String)buffer_st.method_19772());
        class_3448 class_34482 = statType = class_7923.field_41193.method_10250(statTypeId) ? (class_3448)class_7923.field_41193.method_17966(statTypeId).get() : null;
        if (statType == null) {
            return;
        }
        class_2378 statTypeRegistry = statType.method_14959();
        while (buffer_st.readableBytes() > 0) {
            class_2960 statId = class_2960.method_60654((String)buffer_st.method_19772());
            int statValue = buffer_st.readIntLE();
            Object item = statTypeRegistry.method_17966(statId).orElse(null);
            if (item == null) continue;
            statsProvider.setStatValue(statType, item, statValue);
        }
    }

    private static final void read_fileChunk_playerBadges(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String playerBadgeIdPath = buffer_chunk.method_19772();
                int value = buffer_chunk.method_10816();
                class_2960 playerBadgeId = class_2960.method_60655((String)modId, (String)playerBadgeIdPath);
                statsProvider.setPlayerBadgeValue(playerBadgeId, value);
            }
        }
    }
}

