/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.screen;

import io.github.thecsdev.betterstats.api.client.gui.screen.BetterStatsScreenWrapper;
import io.github.thecsdev.betterstats.api.client.registry.BSStatsTabs;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatsTabPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.BetterStatsPanel;
import io.github.thecsdev.betterstats.client.network.BetterStatsClientPlayNetworkHandler;
import io.github.thecsdev.betterstats.client.network.OtherClientPlayerStatsProvider;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenPlus;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsScreen
extends TScreenPlus
implements IParentScreenProvider {
    @Nullable
    private final Screen parent;
    private final IStatsProvider statsProvider;
    @Nullable
    private StatsTab selectedStatsTab = BSStatsTabs.GENERAL;
    private final StatFilterSettings filterSettings = new StatFilterSettings();
    private boolean statsAlreadyRequested = false;
    @Nullable
    private BetterStatsPanel bsPanel;

    public BetterStatsScreen(@Nullable Screen parent) throws NullPointerException {
        this(parent, LocalPlayerStatsProvider.getInstance());
    }

    public BetterStatsScreen(@Nullable Screen parent, IStatsProvider statsProvider) throws NullPointerException {
        super((Component)TextUtils.translatable((String)"gui.stats", (Object[])new Object[0]));
        this.parent = parent;
        this.statsProvider = Objects.requireNonNull(statsProvider);
    }

    protected final TScreenWrapper<?> createScreenWrapper() {
        return new BetterStatsScreenWrapper(this);
    }

    public final Screen getParentScreen() {
        return this.parent;
    }

    public final boolean shouldPause() {
        return true;
    }

    public final boolean shouldRenderInGameHud() {
        return false;
    }

    public final void close() {
        this.getClient().setScreen(this.parent);
    }

    protected final void onOpened() {
        if (this.statsAlreadyRequested) {
            return;
        }
        this.statsAlreadyRequested = true;
        try {
            if (this.client.player == null || this.client.player.connection == null) {
                return;
            }
            if (this.statsProvider == LocalPlayerStatsProvider.getInstance()) {
                this.client.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
            } else {
                IStatsProvider iStatsProvider = this.statsProvider;
                if (iStatsProvider instanceof OtherClientPlayerStatsProvider) {
                    OtherClientPlayerStatsProvider ssps = (OtherClientPlayerStatsProvider)iStatsProvider;
                    BetterStatsClientPlayNetworkHandler.getInstance().sendMcbsRequest(ssps.getPlayerName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void onClosed() {
        double val = this.bsPanel.getStatsTabVerticalScrollAmount();
        this.filterSettings.setProperty(StatsTabPanel.FILTER_ID_SCROLL_CACHE, new Double[]{val});
    }

    public final IStatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @Nullable
    public final StatsTab getStatsTab() {
        return this.selectedStatsTab;
    }

    public final void setStatsTab(@Nullable StatsTab statsTab) {
        this.selectedStatsTab = statsTab;
        this.refresh();
    }

    public final void refresh() {
        if (!this.isOpen()) {
            return;
        }
        this.clearChildren();
        this.init();
    }

    protected final void init() {
        this.bsPanel = new BetterStatsPanel(0, 0, this.getWidth(), this.getHeight(), new BetterStatsPanel.BetterStatsPanelProxy(){

            @Override
            public IStatsProvider getStatsProvider() {
                return BetterStatsScreen.this.statsProvider;
            }

            @Override
            public StatsTab getSelectedStatsTab() {
                return BetterStatsScreen.this.selectedStatsTab;
            }

            @Override
            public void setSelectedStatsTab(StatsTab statsTab) {
                BetterStatsScreen.this.setStatsTab(statsTab);
            }

            @Override
            public final StatFilterSettings getFilterSettings() {
                return BetterStatsScreen.this.filterSettings;
            }
        });
        this.addChild((TElement)this.bsPanel, false);
    }

    public final boolean filesDragged(Collection<Path> files) {
        if (files.size() != 1) {
            return false;
        }
        Path file = files.iterator().next();
        if (!file.toString().endsWith("." + "mcbs".toLowerCase())) {
            return false;
        }
        try {
            IEditableStatsProvider stats = StatsProviderIO.loadFromFile(file.toFile());
            Screen screen = new BetterStatsScreen(this.parent, stats).getAsScreen();
            BetterStatsClient.MC_CLIENT.setScreen(screen);
        }
        catch (IOException exc) {
            return false;
        }
        return true;
    }
}

