/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.widget;

import io.github.thecsdev.betterstats.api.client.gui.stats.widget.AbstractStatWidget;
import io.github.thecsdev.betterstats.api.util.formatters.StatValueFormatter;
import io.github.thecsdev.betterstats.api.util.stats.SUGeneralStat;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.Objects;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
public class GeneralStatWidget
extends AbstractStatWidget<SUGeneralStat> {
    public static final int HEIGHT;
    protected final Component txt_label;
    protected Component txt_value;
    protected final Tooltip defaultTooltip;
    @ApiStatus.Experimental
    protected StatValueFormatter formatter;

    public GeneralStatWidget(int x, int y, int width, SUGeneralStat stat) throws NullPointerException {
        super(x, y, width, HEIGHT, stat);
        this.txt_label = stat.getStatLabel();
        this.setFormatter(null);
        MutableComponent ttt = TextUtils.literal((String)"").append(stat.getStatLabel()).append((Component)TextUtils.fLiteral((String)("\n\u00a77K: " + String.valueOf(stat.getStatID())))).append((Component)TextUtils.fLiteral((String)("\n\u00a77V: " + String.valueOf(stat.getGeneralStat().getValue())))).append("\n\n\u00a7r").append((Component)TextUtils.fLiteral((String)("\u00a7e" + SUGeneralStat.TEXT_VALUE.getString() + ": \u00a7r" + stat.value)));
        this.defaultTooltip = Tooltip.create((Component)ttt);
        this.setTooltip(this.defaultTooltip);
    }

    @ApiStatus.Experimental
    public final StatValueFormatter getFormatter() {
        return this.formatter;
    }

    @ApiStatus.Experimental
    public final void setFormatter(@Nullable StatValueFormatter formatter) {
        this.formatter = formatter != null ? formatter : new StatValueFormatter(){

            @Override
            public final Component getDisplayName() {
                return TextUtils.literal((String)"-");
            }

            @Override
            public final Component format(int number) {
                return ((SUGeneralStat)GeneralStatWidget.this.stat).valueText;
            }
        };
        this.txt_value = this.formatter.format(((SUGeneralStat)this.stat).value);
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        super.render(pencil);
        pencil.drawTElementTextTH(this.txt_label, HorizontalAlignment.LEFT);
        pencil.drawTElementTextTH(this.txt_value, HorizontalAlignment.RIGHT);
    }

    static {
        Objects.requireNonNull(TCDCommonsClient.MC_CLIENT.font);
        HEIGHT = 9 + 8;
    }
}

