/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import org.jetbrains.annotations.Nullable;

public final class LocalPlayerStatsProvider
implements IStatsProvider {
    private static LocalPlayerStatsProvider INSTANCE = null;
    private final LocalPlayer player;
    private final Component displayName;
    private final GameProfile gameProfile;
    private final StatsCounter statsHandler;
    private final PlayerBadgeHandler badgeHandler;

    private LocalPlayerStatsProvider(LocalPlayer player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.displayName = player.getDisplayName();
        this.gameProfile = player.getGameProfile();
        this.statsHandler = player.getStats();
        this.badgeHandler = ClientPlayerBadge.getClientPlayerBadgeHandler((LocalPlayer)player);
    }

    public final LocalPlayer getPlayer() {
        return this.player;
    }

    @Override
    public final Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public final GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public final int getStatValue(Stat<?> stat) {
        return this.statsHandler.getValue(stat);
    }

    @Override
    public final <T> int getStatValue(StatType<T> type, T stat) {
        return this.statsHandler.getValue(type, stat);
    }

    @Override
    public final int getPlayerBadgeValue(ResourceLocation badgeId) {
        return this.badgeHandler.getValue(badgeId);
    }

    public final int hashCode() {
        return this.player.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalPlayerStatsProvider lpsp = (LocalPlayerStatsProvider)obj;
        return this.player == lpsp.player;
    }

    @Nullable
    public static final LocalPlayerStatsProvider getInstance() {
        LocalPlayer player = BetterStatsClient.MC_CLIENT.player;
        if (player == null) {
            INSTANCE = null;
            return null;
        }
        if (INSTANCE == null || LocalPlayerStatsProvider.INSTANCE.player != player) {
            INSTANCE = new LocalPlayerStatsProvider(player);
        }
        return INSTANCE;
    }

    public static final LocalPlayerStatsProvider of(LocalPlayer player) throws NullPointerException {
        Objects.requireNonNull(player);
        return INSTANCE != null && LocalPlayerStatsProvider.INSTANCE.player == player ? INSTANCE : new LocalPlayerStatsProvider(player);
    }
}

