/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.registry;

import io.github.thecsdev.betterstats.api.util.formatters.StatValueFormatter;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.registry.TMutableRegistry;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BSRegistries {
    public static final Map<String, Function<ResourceLocation, String>> ITEM_WIKIS;
    public static final Map<String, Function<ResourceLocation, String>> MOB_WIKIS;
    @Deprecated(since="3.9.1", forRemoval=true)
    public static final Map<StatType<EntityType<?>>, Function<SUMobStat, Component>> ENTITY_STAT_TEXT_FORMATTER;
    public static final Map<StatType<EntityType<?>>, Component> ENTITY_STAT_PHRASE;
    @ApiStatus.Experimental
    public static final TMutableRegistry<StatValueFormatter> STAT_TIME_FORMATTER;
    @ApiStatus.Experimental
    public static final TMutableRegistry<StatValueFormatter> STAT_DISTANCE_FORMATTER;

    private BSRegistries() {
    }

    @Nullable
    public static final String getItemWikiURL(ResourceLocation itemId) throws NullPointerException {
        Objects.requireNonNull(itemId);
        Function<ResourceLocation, String> supplier = ITEM_WIKIS.get(itemId.getNamespace());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(itemId);
    }

    @Nullable
    public static final String getMobWikiURL(ResourceLocation entityId) throws NullPointerException {
        Objects.requireNonNull(entityId);
        Function<ResourceLocation, String> supplier = MOB_WIKIS.get(entityId.getNamespace());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(entityId);
    }

    public static final Component getEntityStatTypePhrase(StatType<EntityType<?>> statType) {
        if (statType == null) {
            return TextUtils.literal((String)"null");
        }
        Component esp = ENTITY_STAT_PHRASE.get(statType);
        if (esp != null) {
            return esp;
        }
        ResourceLocation statTypeId = BuiltInRegistries.STAT_TYPE.getKey(statType);
        if (statTypeId != null) {
            MutableComponent phrase;
            String stKey = statTypeId.toString().replace(':', '.');
            String tKey = "betterstats.stattype_phrase." + stKey;
            if (!Objects.equals(tKey, (phrase = Component.translatable((String)tKey)).getString())) {
                return phrase;
            }
            return TextUtils.literal((String)statTypeId.toString());
        }
        return TextUtils.literal((String)"null");
    }

    static {
        STAT_TIME_FORMATTER = new TMutableRegistry();
        STAT_DISTANCE_FORMATTER = new TMutableRegistry();
        ITEM_WIKIS = new TreeMap<String, Function<ResourceLocation, String>>(String.CASE_INSENSITIVE_ORDER);
        MOB_WIKIS = new TreeMap<String, Function<ResourceLocation, String>>(String.CASE_INSENSITIVE_ORDER);
        ENTITY_STAT_TEXT_FORMATTER = new HashMap();
        ENTITY_STAT_PHRASE = new HashMap();
        String mc = ResourceLocation.parse((String)"air").getNamespace();
        ITEM_WIKIS.put(mc, id -> "https://minecraft.wiki/" + id.getPath());
        MOB_WIKIS.put(mc, id -> "https://minecraft.wiki/" + id.getPath());
        ENTITY_STAT_TEXT_FORMATTER.put(Stats.ENTITY_KILLED, stat -> TextUtils.literal((String)"").append(BSRegistries.getEntityStatTypePhrase(Stats.ENTITY_KILLED)).append(": " + stat.kills));
        ENTITY_STAT_TEXT_FORMATTER.put(Stats.ENTITY_KILLED_BY, stat -> TextUtils.literal((String)"").append(BSRegistries.getEntityStatTypePhrase(Stats.ENTITY_KILLED_BY)).append(": " + stat.deaths));
        ENTITY_STAT_PHRASE.put(Stats.ENTITY_KILLED, (Component)BST.stp_mc_killed());
        ENTITY_STAT_PHRASE.put(Stats.ENTITY_KILLED_BY, (Component)BST.stp_mc_killedBy());
    }
}

