/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.enumerations;

import io.github.thecsdev.betterstats.api.util.BSUtils;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfoProvider;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public enum FilterGroupBy implements ITextProvider
{
    DEFAULT((Component)BST.filter_groupBy_default()),
    ALL((Component)TextUtils.translatable((String)"gui.all", (Object[])new Object[0])),
    MOD((Component)BST.filter_groupBy_mod());

    private final Component text;

    private FilterGroupBy(Component text) {
        this.text = Objects.requireNonNull(text);
    }

    public final Component getText() {
        return this.text;
    }

    @SafeVarargs
    public final <S extends SUStat<?>> Map<Component, List<S>> apply(Iterable<S> stats, S ... typeClassGetter) throws NullPointerException {
        Objects.requireNonNull(stats);
        Objects.requireNonNull(typeClassGetter);
        if (!stats.iterator().hasNext()) {
            return new HashMap<Component, List<S>>();
        }
        switch (this.ordinal()) {
            case 1: {
                return FilterGroupBy.apply_all(stats);
            }
            case 2: {
                return FilterGroupBy.apply_mod(stats);
            }
        }
        Class<?> type = Objects.requireNonNull(typeClassGetter.getClass().getComponentType());
        if (type.equals(SUItemStat.class)) {
            Iterable<SUItemStat> statsI = stats;
            return FilterGroupBy.apply_itemGroups(statsI);
        }
        return FilterGroupBy.apply_mod(stats);
    }

    private static final <S extends SUStat<?>> Map<Component, List<S>> apply_all(Iterable<S> stats) {
        HashMap<Component, List<S>> map = new HashMap<Component, List<S>>();
        ArrayList<S> list = new ArrayList<S>(StreamSupport.stream(stats.spliterator(), false).toList());
        map.put((Component)TextUtils.literal((String)"*"), (List<S>)list);
        return map;
    }

    private static final <S extends SUStat<?>> Map<Component, List<S>> apply_mod(Iterable<S> stats) {
        ModInfoProvider mip = Objects.requireNonNull(ModInfoProvider.getInstance());
        LinkedHashMap map = new LinkedHashMap();
        StreamSupport.stream(stats.spliterator(), false).forEach(stat -> {
            String groupName = stat.getStatID().getNamespace();
            LinkedList<SUStat> group = (LinkedList<SUStat>)map.get(groupName);
            if (group == null) {
                group = new LinkedList<SUStat>();
                map.put(groupName, group);
            }
            group.add((SUStat)stat);
        });
        return map.entrySet().stream().map(mapEntry -> {
            @Nullable ModInfo modInfo = mip.getModInfo((String)mapEntry.getKey());
            Component newKey = modInfo != null ? modInfo.getName() : TextUtils.literal((String)((String)mapEntry.getKey()));
            return new AbstractMap.SimpleEntry<Component, List>(newKey, (List)mapEntry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new));
    }

    private static final <S extends SUStat<?>> Map<Component, List<S>> apply_itemGroups(Iterable<SUItemStat> stats) {
        LinkedHashMap map = new LinkedHashMap();
        map.put(null, new LinkedList());
        stats.forEach(stat -> {
            CreativeModeTab itemGroup = BSUtils.getItemGroup(stat.getItem());
            LinkedList<SUItemStat> group = (LinkedList<SUItemStat>)map.get(itemGroup);
            if (group == null) {
                group = new LinkedList<SUItemStat>();
                map.put(itemGroup, group);
            }
            group.add((SUItemStat)stat);
        });
        map.entrySet().removeIf(e -> ((List)e.getValue()).size() == 0);
        return map.entrySet().stream().map(mapEntry -> {
            MutableComponent name = mapEntry.getKey() != null ? ((CreativeModeTab)mapEntry.getKey()).getDisplayName() : TextUtils.literal((String)"*");
            return new AbstractMap.SimpleEntry<MutableComponent, List>(name, (List)mapEntry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new));
    }
}

