/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.enumerations;

import io.github.thecsdev.betterstats.api.util.enumerations.ItemStatType;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;

public enum FilterSortItemsBy implements ITextProvider
{
    DEFAULT((Component)BST.filter_groupBy_default()),
    MINED(ItemStatType.MINED.getText()),
    CRAFTED(ItemStatType.CRAFTED.getText()),
    USED(ItemStatType.USED.getText()),
    BROKEN(ItemStatType.BROKEN.getText()),
    PICKED_UP(ItemStatType.PICKED_UP.getText()),
    DROPPED(ItemStatType.DROPPED.getText());

    private final Component text;

    private FilterSortItemsBy(Component text) {
        this.text = Objects.requireNonNull(text);
    }

    public final Component getText() {
        return this.text;
    }

    public final void sortItemStats(Map<?, List<SUItemStat>> stats) {
        FilterSortItemsBy.sortItemStats(stats, this);
    }

    public final void sortItemStats(List<SUItemStat> stats) {
        FilterSortItemsBy.sortItemStats(stats, this);
    }

    public static final void sortItemStats(Map<?, List<SUItemStat>> stats, FilterSortItemsBy sortBy) {
        for (Map.Entry<?, List<SUItemStat>> entry : stats.entrySet()) {
            FilterSortItemsBy.sortItemStats(entry.getValue(), sortBy);
        }
    }

    public static final void sortItemStats(List<SUItemStat> stats, FilterSortItemsBy sortBy) {
        switch (sortBy.ordinal()) {
            case 1: {
                Collections.sort(stats, (s1, s2) -> Integer.compare(s2.mined, s1.mined));
                break;
            }
            case 2: {
                Collections.sort(stats, (s1, s2) -> Integer.compare(s2.crafted, s1.crafted));
                break;
            }
            case 3: {
                Collections.sort(stats, (s1, s2) -> Integer.compare(s2.used, s1.used));
                break;
            }
            case 4: {
                Collections.sort(stats, (s1, s2) -> Integer.compare(s2.broken, s1.broken));
                break;
            }
            case 5: {
                Collections.sort(stats, (s1, s2) -> Integer.compare(s2.pickedUp, s1.pickedUp));
                break;
            }
            case 6: {
                Collections.sort(stats, (s1, s2) -> Integer.compare(s2.dropped, s1.dropped));
                break;
            }
        }
    }
}

