/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.formatters;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class StatValueFormatter {
    public static final StatValueFormatter TIME = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"-");
        }

        @Override
        public final Component format(int ticks) {
            return TextUtils.literal((String)StatFormatter.TIME.format(ticks));
        }
    };
    public static final StatValueFormatter TIME_TICKS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"20/s");
        }

        @Override
        public final Component format(int ticks) {
            return TextUtils.literal((String)Integer.toString(ticks));
        }
    };
    public static final StatValueFormatter TIME_MILLISECONDS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"ms");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(0.02)).append(" ms");
        }
    };
    public static final StatValueFormatter TIME_SECONDS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"s");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(20)).append(" s");
        }
    };
    public static final StatValueFormatter TIME_MINUTES = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"m");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(1200)).append(" m");
        }
    };
    public static final StatValueFormatter TIME_HOURS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"h");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(72000)).append(" h");
        }
    };
    public static final StatValueFormatter TIME_DAYS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"d");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(1728000)).append(" d");
        }
    };
    public static final StatValueFormatter TIME_WEEKS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"w");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(12096000)).append(" w");
        }
    };
    public static final StatValueFormatter TIME_YEARS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"y");
        }

        @Override
        public final Component format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(631152000)).append(" y");
        }
    };
    public static final StatValueFormatter TIME_HH_MM_SS_MS = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"hh:mm:ss.ms");
        }

        @Override
        public final Component format(int ticks) {
            int TICKS_PER_SECOND = 20;
            int SECONDS_PER_MINUTE = 60;
            int MINUTES_PER_HOUR = 60;
            int totalSeconds = ticks / 20;
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            int seconds = totalSeconds % 60;
            int milliseconds = ticks % 20 * 50;
            String result = String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds);
            return TextUtils.literal((String)result);
        }
    };
    public static final StatValueFormatter DISTANCE = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"-");
        }

        @Override
        public final Component format(int cm) {
            return TextUtils.literal((String)StatFormatter.DISTANCE.format(cm));
        }
    };
    public static final StatValueFormatter DISTANCE_CENTIMETER = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"cm");
        }

        @Override
        public final Component format(int cm) {
            return TextUtils.literal((String)Integer.toString(cm)).append(" cm");
        }
    };
    public static final StatValueFormatter DISTANCE_METER = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"m");
        }

        @Override
        public final Component format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(100)).append(" m");
        }
    };
    public static final StatValueFormatter DISTANCE_KILOMETER = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"km");
        }

        @Override
        public final Component format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(100000)).append(" km");
        }
    };
    public static final StatValueFormatter DISTANCE_INCH = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"in");
        }

        @Override
        public final Component format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(2.54)).append(" in");
        }
    };
    public static final StatValueFormatter DISTANCE_FOOT = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"ft");
        }

        @Override
        public final Component format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(30.48)).append(" ft");
        }
    };
    public static final StatValueFormatter DISTANCE_YARD = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"yd");
        }

        @Override
        public final Component format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(91.44)).append(" yd");
        }
    };
    public static final StatValueFormatter DISTANCE_MILE = new StatValueFormatter(){

        @Override
        public final Component getDisplayName() {
            return TextUtils.literal((String)"mi");
        }

        @Override
        public final Component format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(160934.4)).append(" mi");
        }
    };

    public abstract Component getDisplayName();

    public abstract Component format(int var1);

    @ApiStatus.Internal
    private static final String fdn(String str) {
        str = str.length() > 7 ? str.substring(0, 7) : str;
        str = str.replaceAll("(\\.)?0*$", "");
        return str;
    }

    private static final MutableComponent calc(int input, BigDecimal divisor) {
        BigDecimal num = new BigDecimal(input).divide(divisor, 5, RoundingMode.DOWN);
        return TextUtils.literal((String)StatValueFormatter.fdn(num.toString()));
    }

    static {
        String modId = BetterStats.getModID();
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"default"), (Object)TIME);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"ms"), (Object)TIME_MILLISECONDS);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"s"), (Object)TIME_SECONDS);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"m"), (Object)TIME_MINUTES);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"h"), (Object)TIME_HOURS);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"d"), (Object)TIME_DAYS);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"w"), (Object)TIME_WEEKS);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"y"), (Object)TIME_YEARS);
        BSRegistries.STAT_TIME_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"hh_mm_ss_ms"), (Object)TIME_HH_MM_SS_MS);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"default"), (Object)DISTANCE);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"cm"), (Object)DISTANCE_CENTIMETER);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"m"), (Object)DISTANCE_METER);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"km"), (Object)DISTANCE_KILOMETER);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"in"), (Object)DISTANCE_INCH);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"ft"), (Object)DISTANCE_FOOT);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"yd"), (Object)DISTANCE_YARD);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(ResourceLocation.fromNamespaceAndPath((String)modId, (String)"mi"), (Object)DISTANCE_MILE);
    }
}

