/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.RAMStatsProvider;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import org.jetbrains.annotations.Nullable;

public interface IEditableStatsProvider
extends IStatsProvider {
    public void setDisplayName(@Nullable Component var1);

    public void setGameProfile(@Nullable GameProfile var1);

    public void setStatValue(Stat<?> var1, int var2) throws NullPointerException;

    default public <T> void setStatValue(StatType<T> type, T stat, int value) throws NullPointerException {
        this.setStatValue(type.get(stat), value);
    }

    default public void increaseStatValue(Stat<?> stat, int value) {
        int i = (int)Math.min((long)this.getStatValue(stat) + (long)value, Integer.MAX_VALUE);
        this.setStatValue(stat, i);
    }

    default public <T> void increaseStatValue(StatType<T> type, T stat, int value) {
        this.increaseStatValue(type.get(stat), value);
    }

    public void setPlayerBadgeValue(ResourceLocation var1, int var2) throws NullPointerException;

    default public void setPlayerBadgeValue(PlayerBadge playerBadge, int value) throws NullPointerException {
        this.setPlayerBadgeValue(Objects.requireNonNull(playerBadge.getId().orElse(null)), value);
    }

    default public void setAll(RAMStatsProvider from) throws NullPointerException {
        Objects.requireNonNull(from);
        Object2IntMap<Stat<?>> stm = from.getStatMap();
        Object2IntMap<ResourceLocation> pbm = from.getPlayerBadgeStatMap();
        stm.forEach((k, v) -> this.setStatValue((Stat<?>)k, (int)v));
        pbm.forEach((k, v) -> this.setPlayerBadgeValue((ResourceLocation)k, (int)v));
    }
}

