/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.EmptyStatsProvider;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import org.jetbrains.annotations.Nullable;

public interface IStatsProvider {
    public static final IStatsProvider EMPTY = new EmptyStatsProvider();

    @Nullable
    public Component getDisplayName();

    @Nullable
    public GameProfile getGameProfile();

    public int getStatValue(Stat<?> var1);

    default public <T> int getStatValue(StatType<T> type, T stat) {
        return type.contains(stat) ? this.getStatValue(type.get(stat)) : 0;
    }

    public int getPlayerBadgeValue(ResourceLocation var1);

    default public int getPlayerBadgeValue(PlayerBadge playerBadge) throws NullPointerException {
        return this.getPlayerBadgeValue(Objects.requireNonNull(playerBadge.getId().orElse(null)));
    }
}

