/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.tcdcommons.api.badge.ServerPlayerBadgeHandler;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;

public final class ServerPlayerStatsProvider
implements IStatsProvider {
    private final ServerPlayer player;
    private final Component displayName;
    private final GameProfile gameProfile;
    private final ServerStatsCounter statHandler;
    private final ServerPlayerBadgeHandler badgeHandler;

    private ServerPlayerStatsProvider(ServerPlayer player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.displayName = player.getDisplayName();
        this.gameProfile = player.getGameProfile();
        this.statHandler = player.getStats();
        this.badgeHandler = ServerPlayerBadgeHandler.getServerBadgeHandler((ServerPlayer)player);
    }

    public final ServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    public final Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public final GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public final int getStatValue(Stat<?> stat) {
        return this.statHandler.getValue(stat);
    }

    @Override
    public final <T> int getStatValue(StatType<T> type, T stat) {
        return this.statHandler.getValue(type, stat);
    }

    @Override
    public final int getPlayerBadgeValue(ResourceLocation badgeId) {
        return this.badgeHandler.getValue(badgeId);
    }

    public final int hashCode() {
        return this.player.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerPlayerStatsProvider spsp = (ServerPlayerStatsProvider)obj;
        return this.player == spsp.player;
    }

    public static final ServerPlayerStatsProvider of(ServerPlayer player) throws NullPointerException {
        return new ServerPlayerStatsProvider(player);
    }
}

