/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StatsProviderIO_fv2 {
    static final void write_fileChunks(FriendlyByteBuf buffer_file, IStatsProvider statsProvider) {
        StatsProviderIO_fv2.write_fileChunk("metadata", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("general", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("item", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("mob", buffer_file, statsProvider);
        StatsProviderIO_fv2.write_fileChunk("player_badge", buffer_file, statsProvider);
    }

    private static final void write_fileChunk(String chunkId, FriendlyByteBuf buffer_file, IStatsProvider statsProvider) {
        FriendlyByteBuf buffer_chunk = new FriendlyByteBuf(Unpooled.buffer());
        buffer_chunk.writeUtf(chunkId);
        switch (chunkId) {
            case "metadata": {
                StatsProviderIO_fv2.write_fileChunk_meta(buffer_chunk, statsProvider);
                break;
            }
            case "general": {
                StatsProviderIO_fv2.write_fileChunk_general(buffer_chunk, statsProvider);
                break;
            }
            case "item": {
                StatsProviderIO_fv2.write_fileChunk_item(buffer_chunk, statsProvider);
                break;
            }
            case "mob": {
                StatsProviderIO_fv2.write_fileChunk_mob(buffer_chunk, statsProvider);
                break;
            }
            case "player_badge": {
                StatsProviderIO_fv2.write_fileChunk_playerBadge(buffer_chunk, statsProvider);
                break;
            }
        }
        buffer_file.writeIntLE(buffer_chunk.readableBytes());
        buffer_file.writeBytes((ByteBuf)buffer_chunk);
        buffer_chunk.release();
    }

    private static final void write_fileChunk_meta(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        @Nullable Component displayName = statsProvider.getDisplayName();
        if (displayName == null) {
            displayName = TextUtils.literal((String)"-");
        }
        buffer_chunk.writeWithCodec((DynamicOps)NbtOps.INSTANCE, ComponentSerialization.CODEC, (Object)displayName);
        StatsProviderIO_fv2.writeGameProfile(buffer_chunk, statsProvider.getGameProfile());
    }

    private static final void write_fileChunk_general(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        ArrayList customStats = Lists.newArrayList((Iterator)BuiltInRegistries.CUSTOM_STAT.iterator());
        Map<String, List<ResourceLocation>> customStatsMap = customStats.stream().filter(stat -> BuiltInRegistries.CUSTOM_STAT.getKey(stat) != null).filter(stat -> statsProvider.getStatValue(Stats.CUSTOM.get(stat)) != 0).collect(Collectors.groupingBy(stat -> BuiltInRegistries.CUSTOM_STAT.getKey(stat).getNamespace()));
        for (Map.Entry<String, List<ResourceLocation>> entry : customStatsMap.entrySet()) {
            String groupModId = entry.getKey();
            List<ResourceLocation> groupStats = entry.getValue();
            buffer_chunk.writeUtf(groupModId);
            buffer_chunk.writeVarInt(groupStats.size());
            for (ResourceLocation customStatAsIdentifier : groupStats) {
                Stat customStat = Stats.CUSTOM.get((Object)customStatAsIdentifier);
                int customStatValue = statsProvider.getStatValue(customStat);
                buffer_chunk.writeUtf(customStatAsIdentifier.getPath());
                buffer_chunk.writeVarInt(customStatValue);
            }
        }
    }

    private static final void write_fileChunk_item(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUItemStat>> stats = SUItemStat.getItemStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUItemStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUItemStat> groupStats = entry.getValue();
            buffer_chunk.writeUtf(groupModId);
            buffer_chunk.writeVarInt(groupStats.size());
            for (SUItemStat stat2 : groupStats) {
                buffer_chunk.writeUtf(stat2.getStatID().getPath());
                buffer_chunk.writeVarInt(stat2.mined);
                buffer_chunk.writeVarInt(stat2.crafted);
                buffer_chunk.writeVarInt(stat2.used);
                buffer_chunk.writeVarInt(stat2.broken);
                buffer_chunk.writeVarInt(stat2.pickedUp);
                buffer_chunk.writeVarInt(stat2.dropped);
            }
        }
    }

    private static final void write_fileChunk_mob(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUMobStat>> stats = SUMobStat.getMobStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUMobStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUMobStat> groupStats = entry.getValue();
            buffer_chunk.writeUtf(groupModId);
            buffer_chunk.writeVarInt(groupStats.size());
            for (SUMobStat stat2 : groupStats) {
                buffer_chunk.writeUtf(stat2.getStatID().getPath());
                buffer_chunk.writeVarInt(stat2.kills);
                buffer_chunk.writeVarInt(stat2.deaths);
            }
        }
    }

    private static final void write_fileChunk_playerBadge(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUPlayerBadgeStat>> stats = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUPlayerBadgeStat> groupStats = entry.getValue();
            buffer_chunk.writeUtf(groupModId);
            buffer_chunk.writeVarInt(groupStats.size());
            for (SUPlayerBadgeStat stat2 : groupStats) {
                buffer_chunk.writeUtf(stat2.getStatID().getPath());
                buffer_chunk.writeVarInt(stat2.value);
            }
        }
    }

    static final void read_fileChunks(FriendlyByteBuf buffer_file, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        while (buffer_file.readableBytes() > 0) {
            String chunkId;
            int chunkSize = buffer_file.readIntLE();
            if (buffer_file.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_file.readableBytes());
            }
            FriendlyByteBuf buffer_chunk = new FriendlyByteBuf(buffer_file.readSlice(chunkSize));
            switch (chunkId = buffer_chunk.readUtf()) {
                case "metadata": {
                    StatsProviderIO_fv2.read_fileChunk_meta(buffer_chunk, statsProvider);
                    break;
                }
                case "general": {
                    StatsProviderIO_fv2.read_fileChunk_general(buffer_chunk, statsProvider);
                    break;
                }
                case "item": {
                    StatsProviderIO_fv2.read_fileChunk_item(buffer_chunk, statsProvider);
                    break;
                }
                case "mob": {
                    StatsProviderIO_fv2.read_fileChunk_mob(buffer_chunk, statsProvider);
                    break;
                }
                case "player_badge": {
                    StatsProviderIO_fv2.read_fileChunk_playerBadge(buffer_chunk, statsProvider);
                    break;
                }
            }
        }
    }

    private static final void read_fileChunk_meta(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        Component displayName = (Component)buffer_chunk.readWithCodec((DynamicOps)NbtOps.INSTANCE, ComponentSerialization.CODEC, NbtAccounter.create((long)0x200000L));
        statsProvider.setDisplayName(displayName);
        if (buffer_chunk.readableBytes() < 2) {
            return;
        }
        @Nullable GameProfile gameProfile = StatsProviderIO_fv2.readGameProfile(buffer_chunk);
        statsProvider.setGameProfile(gameProfile);
    }

    private static final void read_fileChunk_general(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.readUtf();
            int entryCount = buffer_chunk.readVarInt();
            for (int i = 0; i < entryCount; ++i) {
                String customStatIdPath = buffer_chunk.readUtf();
                int customStatValue = buffer_chunk.readVarInt();
                ResourceLocation customStatId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)customStatIdPath);
                ResourceLocation customStat = (ResourceLocation)BuiltInRegistries.CUSTOM_STAT.getValue(customStatId);
                if (customStat == null) continue;
                statsProvider.setStatValue(Stats.CUSTOM.get((Object)customStat), customStatValue);
            }
        }
    }

    private static final void read_fileChunk_item(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.readUtf();
            int entryCount = buffer_chunk.readVarInt();
            for (int i = 0; i < entryCount; ++i) {
                Block block;
                String itemIdPath = buffer_chunk.readUtf();
                int mined = buffer_chunk.readVarInt();
                int crafted = buffer_chunk.readVarInt();
                int used = buffer_chunk.readVarInt();
                int broken = buffer_chunk.readVarInt();
                int pickedUp = buffer_chunk.readVarInt();
                int dropped = buffer_chunk.readVarInt();
                ResourceLocation itemId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)itemIdPath);
                @Nullable Item item = (Item)BuiltInRegistries.ITEM.getValue(itemId);
                Block block2 = block = item != null ? Block.byItem((Item)item) : null;
                if (item == null) continue;
                if (block != null) {
                    statsProvider.setStatValue(Stats.BLOCK_MINED, block, mined);
                }
                statsProvider.setStatValue(Stats.ITEM_CRAFTED, item, crafted);
                statsProvider.setStatValue(Stats.ITEM_USED, item, used);
                statsProvider.setStatValue(Stats.ITEM_BROKEN, item, broken);
                statsProvider.setStatValue(Stats.ITEM_PICKED_UP, item, pickedUp);
                statsProvider.setStatValue(Stats.ITEM_DROPPED, item, dropped);
            }
        }
    }

    private static final void read_fileChunk_mob(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.readUtf();
            int entryCount = buffer_chunk.readVarInt();
            for (int i = 0; i < entryCount; ++i) {
                String mobIdPath = buffer_chunk.readUtf();
                int kills = buffer_chunk.readVarInt();
                int deaths = buffer_chunk.readVarInt();
                ResourceLocation mobId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)mobIdPath);
                @Nullable EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(mobId);
                if (entityType == null) continue;
                statsProvider.setStatValue(Stats.ENTITY_KILLED, entityType, kills);
                statsProvider.setStatValue(Stats.ENTITY_KILLED_BY, entityType, deaths);
            }
        }
    }

    private static final void read_fileChunk_playerBadge(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.readUtf();
            int entryCount = buffer_chunk.readVarInt();
            for (int i = 0; i < entryCount; ++i) {
                String playerBadgeIdPath = buffer_chunk.readUtf();
                int value = buffer_chunk.readVarInt();
                ResourceLocation playerBadgeId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)playerBadgeIdPath);
                statsProvider.setPlayerBadgeValue(playerBadgeId, value);
            }
        }
    }

    private static final void writeGameProfile(FriendlyByteBuf buffer, @Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            buffer.writeBoolean(false);
            buffer.writeBoolean(false);
            return;
        }
        UUID uuid = gameProfile.id();
        String name = gameProfile.name();
        if (uuid != null) {
            buffer.writeBoolean(true);
            buffer.writeUUID(uuid);
        } else {
            buffer.writeBoolean(false);
        }
        if (name != null) {
            buffer.writeBoolean(true);
            buffer.writeUtf(name);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Nullable
    private static final GameProfile readGameProfile(FriendlyByteBuf buffer) {
        String name;
        UUID uuid = buffer.readBoolean() ? buffer.readUUID() : null;
        String string = name = buffer.readBoolean() ? buffer.readUtf() : null;
        if (name == null && uuid == null) {
            return null;
        }
        return new GameProfile(uuid, name);
    }
}

