/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;

public class StatsProviderIO_fv4 {
    static final void write_fileChunks(FriendlyByteBuf buffer_file, IStatsProvider statsProvider) {
        StatsProviderIO_fv4.write_fileChunk("metadata", buffer_file, statsProvider);
        StatsProviderIO_fv4.write_fileChunk("stats", buffer_file, statsProvider);
        StatsProviderIO_fv4.write_fileChunk("tcdcommons:player_badges", buffer_file, statsProvider);
    }

    private static final void write_fileChunk(String chunkId, FriendlyByteBuf buffer_file, IStatsProvider statsProvider) {
        FriendlyByteBuf buffer_chunk = new FriendlyByteBuf(Unpooled.buffer());
        buffer_chunk.writeUtf(chunkId);
        switch (chunkId) {
            case "metadata": {
                StatsProviderIO_fv4.write_fileChunk_metadata(buffer_chunk, statsProvider);
                break;
            }
            case "stats": {
                StatsProviderIO_fv4.write_fileChunk_stats(buffer_chunk, statsProvider);
                break;
            }
            case "tcdcommons:player_badges": {
                StatsProviderIO_fv4.write_fileChunk_playerBadges(buffer_chunk, statsProvider);
                break;
            }
        }
        buffer_file.writeIntLE(buffer_chunk.readableBytes());
        buffer_file.writeBytes((ByteBuf)buffer_chunk);
        buffer_chunk.release();
    }

    private static final void write_fileChunk_metadata(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        Component statsNameText = statsProvider.getDisplayName();
        String statsName = statsNameText != null ? statsNameText.getString() : "-";
        buffer_chunk.writeUtf(statsName);
        StatsProviderIO.writeGameProfile(buffer_chunk, statsProvider.getGameProfile());
    }

    private static final void write_fileChunk_stats(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        for (StatType statType : BuiltInRegistries.STAT_TYPE) {
            FriendlyByteBuf buffer_st = new FriendlyByteBuf(Unpooled.buffer());
            buffer_st.writeUtf(Objects.toString(BuiltInRegistries.STAT_TYPE.getKey((Object)statType)));
            StatsProviderIO_fv4.write_fileChunk_stats_statType(buffer_st, statsProvider, (StatType<Object>)statType);
            buffer_chunk.writeIntLE(buffer_st.readableBytes());
            buffer_chunk.writeBytes((ByteBuf)buffer_st);
            buffer_st.release();
        }
    }

    private static final void write_fileChunk_stats_statType(FriendlyByteBuf buffer_st, IStatsProvider statsProvider, StatType<Object> statType) {
        Registry registry = statType.getRegistry();
        for (Object registryItem : registry) {
            int statValue = statsProvider.getStatValue(statType, registryItem);
            if (statValue == 0) continue;
            ResourceLocation registryItemId = registry.getKey(registryItem);
            buffer_st.writeUtf(registryItemId.getNamespace().equals("minecraft") ? registryItemId.getPath() : Objects.toString(registryItemId));
            buffer_st.writeIntLE(statValue);
        }
    }

    private static final void write_fileChunk_playerBadges(FriendlyByteBuf buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUPlayerBadgeStat>> stats = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUPlayerBadgeStat> groupStats = entry.getValue();
            buffer_chunk.writeUtf(groupModId);
            buffer_chunk.writeVarInt(groupStats.size());
            for (SUPlayerBadgeStat stat2 : groupStats) {
                buffer_chunk.writeUtf(stat2.getStatID().getPath());
                buffer_chunk.writeVarInt(stat2.value);
            }
        }
    }

    static final void read_fileChunks(FriendlyByteBuf buffer_file, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        while (buffer_file.readableBytes() > 0) {
            String chunkId;
            int chunkSize = buffer_file.readIntLE();
            if (buffer_file.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_file.readableBytes());
            }
            FriendlyByteBuf buffer_chunk = new FriendlyByteBuf(buffer_file.readSlice(chunkSize));
            switch (chunkId = buffer_chunk.readUtf()) {
                case "metadata": {
                    StatsProviderIO_fv4.read_fileChunk_metadata(buffer_chunk, statsProvider);
                    break;
                }
                case "stats": {
                    StatsProviderIO_fv4.read_fileChunk_stats(buffer_chunk, statsProvider);
                    break;
                }
                case "tcdcommons:player_badges": {
                    StatsProviderIO_fv4.read_fileChunk_playerBadges(buffer_chunk, statsProvider);
                    break;
                }
            }
        }
    }

    private static final void read_fileChunk_metadata(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        statsProvider.setDisplayName((Component)TextUtils.literal((String)buffer_chunk.readUtf()));
        statsProvider.setGameProfile(StatsProviderIO.readGameProfile(buffer_chunk));
    }

    private static final void read_fileChunk_stats(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) throws IllegalHeaderException {
        while (buffer_chunk.readableBytes() > 0) {
            int chunkSize = buffer_chunk.readIntLE();
            if (buffer_chunk.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_chunk.readableBytes());
            }
            FriendlyByteBuf buffer_st = new FriendlyByteBuf(buffer_chunk.readSlice(chunkSize));
            StatsProviderIO_fv4.read_fileChunk_stats_statType(buffer_st, statsProvider);
        }
    }

    private static final void read_fileChunk_stats_statType(FriendlyByteBuf buffer_st, IEditableStatsProvider statsProvider) {
        StatType statType;
        ResourceLocation statTypeId = ResourceLocation.parse((String)buffer_st.readUtf());
        StatType statType2 = statType = BuiltInRegistries.STAT_TYPE.containsKey(statTypeId) ? (StatType)BuiltInRegistries.STAT_TYPE.getOptional(statTypeId).get() : null;
        if (statType == null) {
            return;
        }
        Registry statTypeRegistry = statType.getRegistry();
        while (buffer_st.readableBytes() > 0) {
            ResourceLocation statId = ResourceLocation.parse((String)buffer_st.readUtf());
            int statValue = buffer_st.readIntLE();
            Object item = statTypeRegistry.getOptional(statId).orElse(null);
            if (item == null) continue;
            statsProvider.setStatValue(statType, item, statValue);
        }
    }

    private static final void read_fileChunk_playerBadges(FriendlyByteBuf buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.readUtf();
            int entryCount = buffer_chunk.readVarInt();
            for (int i = 0; i < entryCount; ++i) {
                String playerBadgeIdPath = buffer_chunk.readUtf();
                int value = buffer_chunk.readVarInt();
                ResourceLocation playerBadgeId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)playerBadgeIdPath);
                statsProvider.setPlayerBadgeValue(playerBadgeId, value);
            }
        }
    }
}

