/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class SUGeneralStat
extends SUStat<ResourceLocation> {
    public static final Component TEXT_VALUE = BST.sWidget_general_value();
    private final Stat<ResourceLocation> stat;
    private final boolean isEmpty;
    public final int value;
    public final Component valueText;

    public SUGeneralStat(IStatsProvider statsProvider, Stat<ResourceLocation> stat) {
        super(statsProvider, SUGeneralStat.id(stat), SUGeneralStat.getGeneralStatText(stat));
        this.stat = Objects.requireNonNull(stat);
        this.value = statsProvider.getStatValue(stat);
        this.valueText = TextUtils.fLiteral((String)stat.format(this.value));
        this.isEmpty = this.value == 0;
    }

    @ApiStatus.Internal
    private static final ResourceLocation id(Stat<ResourceLocation> stat) {
        return Optional.ofNullable(BuiltInRegistries.CUSTOM_STAT.getKey((Object)((ResourceLocation)stat.getValue()))).orElse(ID_NULL);
    }

    public final Stat<ResourceLocation> getGeneralStat() {
        return this.stat;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static String getGeneralStatTranslationKey(Stat<ResourceLocation> stat) {
        return "stat." + ((ResourceLocation)stat.getValue()).toString().replace(':', '.');
    }

    public static Component getGeneralStatText(Stat<ResourceLocation> stat) {
        return TextUtils.fTranslatable((String)SUGeneralStat.getGeneralStatTranslationKey(stat), (Object[])new Object[0]);
    }

    public static List<SUGeneralStat> getGeneralStats(IStatsProvider statsProvider, @Nullable Predicate<SUGeneralStat> filter) {
        Objects.requireNonNull(statsProvider);
        ArrayList<SUGeneralStat> result = new ArrayList<SUGeneralStat>();
        ObjectArrayList statsList = new ObjectArrayList(Stats.CUSTOM.iterator());
        statsList.sort(Comparator.comparing(stat -> TextUtils.translatable((String)SUGeneralStat.getGeneralStatTranslationKey((Stat<ResourceLocation>)stat), (Object[])new Object[0]).getString()));
        for (Stat stat2 : statsList) {
            result.add(new SUGeneralStat(statsProvider, (Stat<ResourceLocation>)stat2));
        }
        result.removeIf(stat -> Objects.equals(ID_NULL, stat.getStatID()) || filter != null && !filter.test((SUGeneralStat)stat));
        return result;
    }
}

