/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.api.util.BSUtils;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class SUItemStat
extends SUStat<Item> {
    protected final Item item;
    @Nullable
    protected final Block block;
    protected final boolean isEmpty;
    public final int mined;
    public final int crafted;
    public final int used;
    public final int broken;
    public final int pickedUp;
    public final int dropped;

    public SUItemStat(IStatsProvider statsProvider, Item item) {
        super(statsProvider, BuiltInRegistries.ITEM.getKey((Object)Objects.requireNonNull(item)), SUItemStat.getItemStatText(item));
        this.item = item;
        this.block = Block.byItem((Item)item);
        this.mined = this.block == null ? 0 : statsProvider.getStatValue(Stats.BLOCK_MINED, this.block);
        this.crafted = statsProvider.getStatValue(Stats.ITEM_CRAFTED, item);
        this.used = statsProvider.getStatValue(Stats.ITEM_USED, item);
        this.broken = statsProvider.getStatValue(Stats.ITEM_BROKEN, item);
        this.pickedUp = statsProvider.getStatValue(Stats.ITEM_PICKED_UP, item);
        this.dropped = statsProvider.getStatValue(Stats.ITEM_DROPPED, item);
        this.isEmpty = this.mined == 0 && this.crafted == 0 && this.used == 0 && this.broken == 0 && this.pickedUp == 0 && this.dropped == 0;
    }

    public final Item getItem() {
        return this.item;
    }

    @Nullable
    public final Block getBlock() {
        return this.block;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static Component getItemStatText(Item item) {
        return TextUtils.fTranslatable((String)item.getDescriptionId(), (Object[])new Object[0]);
    }

    public static List<SUItemStat> getItemStats(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        ArrayList<SUItemStat> result = new ArrayList<SUItemStat>();
        for (Item itemReg : BuiltInRegistries.ITEM) {
            SUItemStat itemStat = new SUItemStat(statsProvider, itemReg);
            if (filter != null && !filter.test(itemStat)) continue;
            result.add(itemStat);
        }
        return result;
    }

    public static Map<CreativeModeTab, List<SUItemStat>> getItemStatsByItemGroups(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        LinkedHashMap<CreativeModeTab, List<SUItemStat>> result = new LinkedHashMap<CreativeModeTab, List<SUItemStat>>();
        result.put(null, new ArrayList());
        for (SUItemStat itemStat : SUItemStat.getItemStats(statsProvider, filter)) {
            CreativeModeTab itemRegGroup = BSUtils.getItemGroup(itemStat.item);
            if (!result.containsKey(itemRegGroup)) {
                result.put(itemRegGroup, new ArrayList());
            }
            result.get(itemRegGroup).add(itemStat);
        }
        if (((List)result.get(null)).size() == 0) {
            result.remove(null);
        }
        return result;
    }

    public static Map<String, List<SUItemStat>> getItemStatsByModGroups(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        LinkedHashMap<String, List<SUItemStat>> result = new LinkedHashMap<String, List<SUItemStat>>();
        String mcModId = "minecraft";
        result.put("minecraft", new ArrayList());
        for (SUItemStat itemStat : SUItemStat.getItemStats(statsProvider, filter)) {
            String itemModId = itemStat.getStatID().getNamespace();
            if (!result.containsKey(itemModId)) {
                result.put(itemModId, Lists.newArrayList());
            }
            List<SUItemStat> resultList = result.get(itemModId);
            resultList.add(itemStat);
        }
        if (((List)result.get("minecraft")).size() == 0) {
            result.remove("minecraft");
        }
        return result;
    }

    @Deprecated(since="3.9.2", forRemoval=true)
    public static Map<Component, List<SUItemStat>> getItemStatsByItemGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        return FilterGroupBy.DEFAULT.apply(SUItemStat.getItemStats(statsProvider, filter), new SUItemStat[0]);
    }

    @Deprecated(since="3.9.2", forRemoval=true)
    public static Map<Component, List<SUItemStat>> getItemStatsByModGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        return FilterGroupBy.MOD.apply(SUItemStat.getItemStats(statsProvider, filter), new SUItemStat[0]);
    }
}

