/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public final class SUMobStat
extends SUStat<EntityType<?>> {
    protected final EntityType<?> entityType;
    protected final boolean isEmpty;
    public final int kills;
    public final int deaths;

    public SUMobStat(IStatsProvider statsProvider, EntityType<?> entityType) {
        super(statsProvider, BuiltInRegistries.ENTITY_TYPE.getKey(Objects.requireNonNull(entityType)), SUMobStat.getMobStatText(entityType));
        this.entityType = entityType;
        this.kills = statsProvider.getStatValue(Stats.ENTITY_KILLED, entityType);
        this.deaths = statsProvider.getStatValue(Stats.ENTITY_KILLED_BY, entityType);
        this.isEmpty = this.kills == 0 && this.deaths == 0;
    }

    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static final Component getMobStatText(EntityType<?> entityType) {
        return TextUtils.fTranslatable((String)entityType.getDescriptionId(), (Object[])new Object[0]);
    }

    public static List<SUMobStat> getMobStats(IStatsProvider statsProvider, @Nullable Predicate<SUMobStat> filter) {
        ArrayList<SUMobStat> result = new ArrayList<SUMobStat>();
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            SUMobStat mobStat = new SUMobStat(statsProvider, entityType);
            if (filter != null && !filter.test(mobStat)) continue;
            result.add(mobStat);
        }
        return result;
    }

    public static Map<String, List<SUMobStat>> getMobStatsByModGroups(IStatsProvider statsProvider, @Nullable Predicate<SUMobStat> filter) {
        LinkedHashMap<String, List<SUMobStat>> result = new LinkedHashMap<String, List<SUMobStat>>();
        String mcModId = "minecraft";
        result.put("minecraft", Lists.newArrayList());
        for (SUMobStat mobStat : SUMobStat.getMobStats(statsProvider, filter)) {
            String entityModId = mobStat.getStatID().getNamespace();
            if (!result.containsKey(entityModId)) {
                result.put(entityModId, Lists.newArrayList());
            }
            Collection resultList = result.get(entityModId);
            resultList.add(mobStat);
        }
        if (((List)result.get("minecraft")).size() == 0) {
            result.remove("minecraft");
        }
        return result;
    }

    public static Map<Component, List<SUMobStat>> getMobStatsByModGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUMobStat> filter) {
        Map<String, List<SUMobStat>> stats = SUMobStat.getMobStatsByModGroups(statsProvider, filter);
        LinkedHashMap<Component, List<SUMobStat>> mapped = new LinkedHashMap<Component, List<SUMobStat>>();
        for (Map.Entry<String, List<SUMobStat>> entry : stats.entrySet()) {
            MutableComponent txt = entry.getKey() != null ? TextUtils.literal((String)TUtils.getModName((String)entry.getKey())) : TextUtils.literal((String)"*");
            mapped.put((Component)txt, entry.getValue());
        }
        return mapped;
    }
}

