/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class SUStat<T> {
    public static final ResourceLocation ID_NULL = ResourceLocation.parse((String)"null");
    protected final IStatsProvider statsProvider;
    protected final ResourceLocation statId;
    protected final Component statLabel;
    protected final String statLabelSQ;
    protected final String statIdSQ;

    protected SUStat(IStatsProvider statsProvider, ResourceLocation statId, Component statLabel) throws NullPointerException {
        this.statsProvider = Objects.requireNonNull(statsProvider);
        this.statId = Objects.requireNonNull(statId);
        this.statLabel = Objects.requireNonNull(statLabel);
        this.statLabelSQ = this.statLabel.getString().toLowerCase().replaceAll("\\s+", "");
        this.statIdSQ = Objects.toString(statId);
    }

    public final Component getStatLabel() {
        return this.statLabel;
    }

    public final ResourceLocation getStatID() {
        return this.statId;
    }

    public final IStatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @Virtual
    public boolean matchesSearchQuery(String search) {
        return this.statLabelSQ.contains(search = StringUtils.defaultString((String)search).toLowerCase().replaceAll("\\s+", "")) || this.statIdSQ.contains(search);
    }

    public abstract boolean isEmpty();
}

