/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen.hud;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreenWrapper;
import io.github.thecsdev.betterstats.client.network.BetterStatsClientPlayNetworkHandler;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TWidgetHudScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsHudScreen
extends TWidgetHudScreen
implements IParentScreenProvider {
    public static final Component TEXT_TITLE = BST.hud_title();
    public static final Component TEXT_TUTORIAL_1 = BST.hud_tutorial1();
    public static final Component TEXT_TUTORIAL_2 = BST.hud_tutorial2();
    public static final Component TEXT_TUTORIAL_3 = BST.hud_tutorial3();
    public static final Component TEXT_LIVE_TOGGLE = BST.hud_liveStatsToggle();
    public static final ResourceLocation HUD_SCREEN_ID = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"stats_hud");
    private static final BetterStatsHudScreen INSTANCE = new BetterStatsHudScreen();
    @Nullable
    private Screen parent;
    @Nullable
    private TButtonWidget btn_done;
    @Nullable
    private TButtonWidget btn_toggleRealtime;
    private float requestTimer = 0.0f;
    private final int requestDelay = 200;

    private BetterStatsHudScreen() {
        super(TEXT_TITLE, HUD_SCREEN_ID);
    }

    protected final TScreenWrapper<?> createScreenWrapper() {
        return new BetterStatsHudScreenWrapper(this);
    }

    protected final void onClosed() {
        super.onClosed();
        if (this.btn_done != null) {
            this.removeChild((TElement)this.btn_done);
            this.btn_done = null;
        }
        if (this.btn_toggleRealtime != null) {
            this.removeChild((TElement)this.btn_toggleRealtime);
            this.btn_toggleRealtime = null;
        }
    }

    protected final void init() {
        if (this.isOpen()) {
            BetterStatsConfig.SHOW_HUD_SCREEN = true;
            BetterStatsClientPlayNetworkHandler bssCpnh = BetterStatsClientPlayNetworkHandler.of(BetterStatsClient.MC_CLIENT.player);
            this.btn_done = new TButtonWidget(this.getWidth() / 2 - 50, this.getHeight() / 2 - 10, 100, 20, (Component)TextUtils.translatable((String)"gui.done", (Object[])new Object[0]));
            this.btn_done.setTooltip(Tooltip.create((Component)TextUtils.literal((String)"").append(TEXT_TUTORIAL_1).append("\n").append(TEXT_TUTORIAL_2).append("\n").append(TEXT_TUTORIAL_3)));
            this.btn_done.setOnClick(__ -> this.close());
            this.addChild((TElement)this.btn_done, false);
            if (bssCpnh.bssNetworkConsent && bssCpnh.serverHasBss) {
                this.btn_toggleRealtime = new TButtonWidget(this.btn_done.getEndX() + 5, this.btn_done.getY(), 20, 20);
                this.btn_toggleRealtime.setTooltip(Tooltip.create((Component)TEXT_LIVE_TOGGLE));
                this.btn_toggleRealtime.setIcon(bssCpnh.netPref_enableLiveStats ? new UITexture(BSComponentPanel.BS_WIDGETS_TEXTURE, new Rectangle(20, 80, 20, 20)) : new UITexture(BSComponentPanel.BS_WIDGETS_TEXTURE, new Rectangle(0, 80, 20, 20)));
                this.btn_toggleRealtime.setOnClick(__ -> {
                    bssCpnh.netPref_enableLiveStats = !bssCpnh.netPref_enableLiveStats;
                    bssCpnh.sendPreferences();
                    this.refresh();
                });
                this.addChild((TElement)this.btn_toggleRealtime, false);
            }
        }
        super.init();
    }

    public final void render(TDrawContext pencil) {
        if (BetterStatsClient.KEYBIND_TOGGLE_HUD.consumeClick() && !this.isOpen()) {
            BetterStatsConfig.SHOW_HUD_SCREEN = !BetterStatsConfig.SHOW_HUD_SCREEN;
            BetterStatsClient.MC_CLIENT.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_HAT, (float)(BetterStatsConfig.SHOW_HUD_SCREEN ? 2.0f : 1.8f)));
        }
        if (!BetterStatsConfig.SHOW_HUD_SCREEN && !this.isOpen()) {
            return;
        }
        super.render(pencil);
        if (this.client == null || this.isOpen()) {
            return;
        }
        this.requestTimer += pencil.deltaTime;
        Objects.requireNonNull(this);
        if (this.requestTimer > 200.0f) {
            this.requestTimer = 0.0f;
            if (BetterStatsClient.MC_CLIENT.screen == null && BetterStatsClient.MC_CLIENT.getOverlay() == null) {
                BetterStatsClient.MC_CLIENT.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
            }
        }
    }

    public static BetterStatsHudScreen getInstance() {
        return INSTANCE;
    }
}

