/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen.hud.entry;

import io.github.thecsdev.betterstats.api.client.gui.stats.widget.CustomStatElement;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.formatters.StatValueFormatter;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUGeneralStat;
import io.github.thecsdev.betterstats.client.network.OtherClientPlayerStatsProvider;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TWidgetHudScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import org.jetbrains.annotations.ApiStatus;

public class StatsHudGeneralEntry
extends TWidgetHudScreen.WidgetEntry<TElement> {
    static final int WIDTH = 100;
    protected IStatsProvider statsProvider;
    protected final ResourceLocation generalStat;
    protected StatType<ResourceLocation> mode = Stats.CUSTOM;
    @ApiStatus.Experimental
    protected final StatValueFormatter formatter;

    public StatsHudGeneralEntry(SUGeneralStat stat, StatValueFormatter formatter) throws NullPointerException {
        this(stat.getStatsProvider(), (ResourceLocation)stat.getGeneralStat().getValue(), formatter);
    }

    public StatsHudGeneralEntry(IStatsProvider statsProvider, ResourceLocation generalStat, StatValueFormatter formatter) throws NullPointerException {
        super(0.5, 0.25);
        this.statsProvider = Objects.requireNonNull(statsProvider);
        this.generalStat = Objects.requireNonNull(generalStat);
        this.formatter = Objects.requireNonNull(formatter);
    }

    public final TElement createWidget() {
        if (this.statsProvider instanceof LocalPlayerStatsProvider) {
            this.statsProvider = Objects.requireNonNull(LocalPlayerStatsProvider.getInstance());
        }
        if (this.mode == null) {
            this.mode = Stats.CUSTOM;
        }
        Element el = new Element();
        el.eContextMenu.register((__, cMenu) -> cMenu.addButton((Component)TextUtils.translatable((String)"selectWorld.delete", (Object[])new Object[0]), ___ -> this.removeEntry()));
        return el;
    }

    private final class Element
    extends TElement {
        private int overlayColor;

        public Element() {
            super(0, 0, 100, CustomStatElement.HEIGHT);
            this.overlayColor = StatsHudGeneralEntry.this.statsProvider instanceof IEditableStatsProvider ? (StatsHudGeneralEntry.this.statsProvider instanceof OtherClientPlayerStatsProvider ? 1996532479 : 0x55FF0000) : 0;
            int rightVar = StatsHudGeneralEntry.this.statsProvider.getStatValue(StatsHudGeneralEntry.this.mode, StatsHudGeneralEntry.this.generalStat);
            MutableComponent left = StatsHudGeneralEntry.this.mode == Stats.CUSTOM ? SUGeneralStat.getGeneralStatText((Stat<ResourceLocation>)StatsHudGeneralEntry.this.mode.get((Object)StatsHudGeneralEntry.this.generalStat)) : TextUtils.literal((String)"<Unsupported stat>");
            Component right = StatsHudGeneralEntry.this.formatter.format(rightVar);
            this.setSize(this.width + this.getTextRenderer().width((FormattedText)left), this.height);
            this.addChild((TElement)new CustomStatElement(0, 0, this.width, (Component)left, right));
        }

        public void render(TDrawContext pencil) {
            pencil.drawTFill(0x50000000);
            pencil.drawTFill(this.overlayColor);
        }
    }
}

