/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen.hud.entry;

import io.github.thecsdev.betterstats.api.client.gui.stats.widget.CustomStatElement;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.ItemStatWidget;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.client.network.OtherClientPlayerStatsProvider;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TWidgetHudScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public final class StatsHudItemEntry
extends TWidgetHudScreen.WidgetEntry<TElement> {
    static final int WIDTH = 100;
    protected IStatsProvider statsProvider;
    protected final Item item;
    @Nullable
    protected final Block block;
    protected StatType<?> mode = Stats.ITEM_USED;

    public StatsHudItemEntry(SUItemStat stat) throws NullPointerException {
        this(stat.getStatsProvider(), stat.getItem());
    }

    public StatsHudItemEntry(IStatsProvider statsProvider, Item item) throws NullPointerException {
        super(0.5, 0.25);
        this.statsProvider = Objects.requireNonNull(statsProvider);
        this.item = Objects.requireNonNull(item);
        Block block = Block.byItem((Item)item);
        this.block = block != Blocks.AIR ? block : null;
    }

    public final TElement createWidget() {
        if (this.statsProvider instanceof LocalPlayerStatsProvider) {
            this.statsProvider = Objects.requireNonNull(LocalPlayerStatsProvider.getInstance());
        }
        Element el = new Element();
        el.eContextMenu.register((__, cMenu) -> {
            for (StatType statType : BuiltInRegistries.STAT_TYPE) {
                boolean isBlock;
                boolean isItem = statType.getRegistry() == BuiltInRegistries.ITEM;
                boolean bl = isBlock = statType.getRegistry() == BuiltInRegistries.BLOCK;
                if (!isItem && !isBlock || isBlock && this.block == null) continue;
                cMenu.addButton(statType.getDisplayName(), ___ -> {
                    this.mode = statType;
                    this.refreshEntry();
                });
            }
            cMenu.addSeparator();
            cMenu.addButton((Component)TextUtils.translatable((String)"selectWorld.delete", (Object[])new Object[0]), ___ -> this.removeEntry());
        });
        return el;
    }

    private final class Element
    extends TElement {
        private int overlayColor;

        public Element() {
            boolean isBlock;
            super(0, 0, 100, CustomStatElement.HEIGHT);
            this.overlayColor = StatsHudItemEntry.this.statsProvider instanceof IEditableStatsProvider ? (StatsHudItemEntry.this.statsProvider instanceof OtherClientPlayerStatsProvider ? 1996532479 : 0x55FF0000) : 0;
            SUItemStat stat = new SUItemStat(StatsHudItemEntry.this.statsProvider, StatsHudItemEntry.this.item);
            this.addChild((TElement)new ItemStatWidget(0, 0, stat), true);
            if (StatsHudItemEntry.this.mode == null) {
                StatsHudItemEntry.this.mode = Stats.ITEM_USED;
            }
            boolean isItem = StatsHudItemEntry.this.mode.getRegistry() == BuiltInRegistries.ITEM;
            boolean bl = isBlock = StatsHudItemEntry.this.mode.getRegistry() == BuiltInRegistries.BLOCK;
            Block valObj = isBlock ? StatsHudItemEntry.this.block : (isItem ? StatsHudItemEntry.this.item : null);
            int val = valObj != null ? stat.getStatsProvider().getStatValue(StatsHudItemEntry.this.mode, valObj) : -1;
            Component left = Optional.ofNullable(StatsHudItemEntry.this.mode.getDisplayName()).orElse((Component)TextUtils.literal((String)Objects.toString(BuiltInRegistries.STAT_TYPE.getKey(StatsHudItemEntry.this.mode))));
            MutableComponent right = TextUtils.literal((String)Integer.toString(val));
            this.setSize(this.width + this.getTextRenderer().width((FormattedText)left), this.height);
            CustomStatElement cse = new CustomStatElement(21, 0, this.width - 21, left, (Component)right);
            this.addChild((TElement)cse, true);
        }

        public void render(TDrawContext pencil) {
            pencil.drawTFill(0x50000000);
            pencil.drawTFill(this.overlayColor);
        }
    }
}

