/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen.hud.entry;

import io.github.thecsdev.betterstats.api.client.gui.stats.widget.CustomStatElement;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.MobStatWidget;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.client.network.OtherClientPlayerStatsProvider;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TWidgetHudScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;

public final class StatsHudMobEntry
extends TWidgetHudScreen.WidgetEntry<TElement> {
    static final int WIDTH = 100;
    protected IStatsProvider statsProvider;
    protected final EntityType<?> entityType;
    protected StatType<EntityType<?>> mode = Stats.ENTITY_KILLED;

    public StatsHudMobEntry(SUMobStat stat) throws NullPointerException {
        this(stat.getStatsProvider(), stat.getEntityType());
    }

    public StatsHudMobEntry(IStatsProvider statsProvider, EntityType<?> entityType) throws NullPointerException {
        super(0.5, 0.25);
        this.statsProvider = Objects.requireNonNull(statsProvider);
        this.entityType = Objects.requireNonNull(entityType);
    }

    public final TElement createWidget() {
        if (this.statsProvider instanceof LocalPlayerStatsProvider) {
            this.statsProvider = Objects.requireNonNull(LocalPlayerStatsProvider.getInstance());
        }
        Element el = new Element();
        el.eContextMenu.register((__, cMenu) -> {
            for (StatType statType : BuiltInRegistries.STAT_TYPE) {
                if (statType.getRegistry() != BuiltInRegistries.ENTITY_TYPE) continue;
                StatType statTypeE = statType;
                cMenu.addButton(BSRegistries.getEntityStatTypePhrase(statTypeE), ___ -> {
                    this.mode = statTypeE;
                    this.refreshEntry();
                });
            }
            cMenu.addSeparator();
            cMenu.addButton((Component)TextUtils.translatable((String)"selectWorld.delete", (Object[])new Object[0]), ___ -> this.removeEntry());
        });
        return el;
    }

    private final class Element
    extends TElement {
        private int overlayColor;

        public Element() {
            super(0, 0, 100, CustomStatElement.HEIGHT);
            this.overlayColor = StatsHudMobEntry.this.statsProvider instanceof IEditableStatsProvider ? (StatsHudMobEntry.this.statsProvider instanceof OtherClientPlayerStatsProvider ? 1996532479 : 0x55FF0000) : 0;
            SUMobStat stat = new SUMobStat(StatsHudMobEntry.this.statsProvider, StatsHudMobEntry.this.entityType);
            MobStatWidget ms = new MobStatWidget(0, 0, stat);
            ms.setSize(this.height, this.height);
            this.addChild((TElement)ms, true);
            if (StatsHudMobEntry.this.mode == null) {
                StatsHudMobEntry.this.mode = Stats.ENTITY_KILLED;
            }
            Component left = BSRegistries.getEntityStatTypePhrase(StatsHudMobEntry.this.mode);
            MutableComponent right = TextUtils.literal((String)Integer.toString(stat.getStatsProvider().getStatValue(StatsHudMobEntry.this.mode, StatsHudMobEntry.this.entityType)));
            this.setSize(this.width + this.getTextRenderer().width((FormattedText)left), this.height);
            CustomStatElement cse = new CustomStatElement(ms.getWidth(), 0, this.width - ms.getWidth(), left, (Component)right);
            this.addChild((TElement)cse, true);
        }

        public void render(TDrawContext pencil) {
            pencil.drawTFill(0x50000000);
            pencil.drawTFill(this.overlayColor);
        }
    }
}

