/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.registry.BSStatsTabs;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.network.BetterStatsClientPlayNetworkHandler;
import io.github.thecsdev.betterstats.network.BetterStatsNetwork;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ActionBarPanel
extends BSComponentPanel {
    public static final int HEIGHT = 22;
    protected final ActionBarPanelProxy proxy;

    public ActionBarPanel(int x, int y, int width, ActionBarPanelProxy proxy) throws NullPointerException {
        super(x, y, width, 22);
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final ActionBarPanelProxy getProxy() {
        return this.proxy;
    }

    protected final void init() {
        BetterStatsClientPlayNetworkHandler bssCpnh = BetterStatsClientPlayNetworkHandler.of(BetterStatsClient.MC_CLIENT.player);
        TButtonWidget btn_close = new TButtonWidget(this.getEndX() - 21, this.getY() + 1, 20, 20);
        btn_close.setEnabled(this.proxy.canClose());
        btn_close.setOnClick(__ -> this.proxy.onClose());
        btn_close.setTooltip(Tooltip.create((Component)TextUtils.translatable((String)"gui.done", (Object[])new Object[0])));
        btn_close.setIcon(new UITexture(BS_WIDGETS_TEXTURE, new Rectangle(0, 60, 20, 20)));
        this.addChild((TElement)btn_close, false);
        TButtonWidget btn_options = new TButtonWidget(btn_close.getX() - 20, btn_close.getY(), 20, 20);
        btn_options.setOnClick(__ -> this.proxy.setSelectedStatsTab(BSStatsTabs.BSS_CONFIG));
        btn_options.setTooltip(Tooltip.create((Component)TextUtils.translatable((String)"options.title", (Object[])new Object[0])));
        btn_options.setIcon(new UITexture(BS_WIDGETS_TEXTURE, new Rectangle(0, 40, 20, 20)));
        this.addChild((TElement)btn_options, false);
        TButtonWidget btn_bssNet = new TButtonWidget(btn_options.getX() - 20, btn_options.getY(), 20, 20);
        btn_bssNet.setTooltip(Tooltip.create((Component)BetterStatsNetwork.TXT_TOGGLE_TOOLTIP));
        btn_bssNet.setIcon(bssCpnh.bssNetworkConsent ? new UITexture(BS_WIDGETS_TEXTURE, new Rectangle(20, 80, 20, 20)) : new UITexture(BS_WIDGETS_TEXTURE, new Rectangle(0, 80, 20, 20)));
        btn_bssNet.setOnClick(__ -> {
            if (bssCpnh.bssNetworkConsent) {
                bssCpnh.sendAndRevokePreferences();
                this.refresh();
                return;
            }
            Screen currentScreen = BetterStatsClient.MC_CLIENT.screen;
            BooleanConsumer confirmScreenCallback = accepted -> {
                bssCpnh.bssNetworkConsent = accepted;
                BetterStatsClient.MC_CLIENT.setScreen(currentScreen);
                if (bssCpnh.bssNetworkConsent) {
                    bssCpnh.sendIHaveBss(true);
                }
            };
            BetterStatsClient.MC_CLIENT.setScreen((Screen)new ConfirmScreen(confirmScreenCallback, BetterStatsNetwork.TXT_TOGGLE_TOOLTIP, BetterStatsNetwork.TXT_CONSENT_WARNING));
        });
        btn_bssNet.setEnabled(bssCpnh.serverHasBss && !BetterStatsClient.MC_CLIENT.isLocalServer() && !bssCpnh.bssNetworkConsent);
        this.addChild((TElement)btn_bssNet, false);
        TButtonWidget btn_credits = new TButtonWidget(this.getX() + 1, this.getY() + 1, 20, 20);
        btn_credits.setOnClick(btn -> this.proxy.setSelectedStatsTab(BSStatsTabs.BSS_CREDITS));
        MutableComponent tt_credits = TextUtils.translatable((String)"credits_and_attribution.button.credits", (Object[])new Object[0]).withStyle(ChatFormatting.YELLOW);
        btn_credits.setTooltip(Tooltip.create((Component)tt_credits));
        btn_credits.setIcon(new UITexture(BS_WIDGETS_TEXTURE, new Rectangle(220, 60, 20, 20)));
        this.addChild((TElement)btn_credits, false);
    }

    public static interface ActionBarPanelProxy {
        public void setSelectedStatsTab(StatsTab var1);

        default public boolean canClose() {
            return true;
        }

        default public void onClose() {
            Screen curr = BetterStatsClient.MC_CLIENT.screen;
            if (curr instanceof IParentScreenProvider) {
                BetterStatsClient.MC_CLIENT.setScreen(((IParentScreenProvider)curr).getParentScreen());
            } else if (curr instanceof TScreenWrapper) {
                TScreen tcurr = ((TScreenWrapper)curr).getTargetTScreen();
                if (tcurr instanceof IParentScreenProvider) {
                    BetterStatsClient.MC_CLIENT.setScreen(((IParentScreenProvider)tcurr).getParentScreen());
                } else {
                    tcurr.close();
                }
            } else if (curr != null) {
                curr.onClose();
            }
        }
    }
}

