/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.widget.AdvancementStatWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIAutomaticSizeLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIHorizontalGridLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TBlankElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.AutomaticSize;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class AdvancementsTab
extends StatsTab {
    @Override
    public final Component getName() {
        return TextUtils.translatable((String)"gui.advancements", (Object[])new Object[0]);
    }

    @Override
    public final boolean isAvailable() {
        return false;
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        ClientPacketListener srv = BetterStatsClient.MC_CLIENT.getConnection();
        if (srv == null) {
            return;
        }
        Map<AdvancementNode, List<AdvancementNode>> aRoots = srv.getAdvancements().getTree().nodes().stream().collect(Collectors.groupingBy(a -> a.root()));
        aRoots.remove(null);
        for (AdvancementNode aRoot : aRoots.keySet()) {
            DisplayInfo arDisplay = aRoot.advancement().display().orElse(null);
            if (arDisplay == null) continue;
            StatsTabUtils.initGroupLabel(panel, arDisplay.getTitle());
            Rectangle n1 = UILayout.nextChildVerticalRect((TParentElement)panel);
            TBlankElement div = new TBlankElement(n1.x, n1.y, n1.width, 0);
            panel.addChild((TElement)div, false);
            for (AdvancementNode advancement : aRoots.get(aRoot)) {
                if (advancement == aRoot) continue;
                AdvancementStatWidget widget = new AdvancementStatWidget(0, 0, advancement);
                div.addChild((TElement)widget, false);
            }
            new UIHorizontalGridLayout().apply((TParentElement)div);
            new UIAutomaticSizeLayout(AutomaticSize.Y).apply((TParentElement)div);
        }
    }
}

