/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.mixin.events;

import io.github.thecsdev.betterstats.api.util.enumerations.ItemStatType;
import io.github.thecsdev.betterstats.api.util.enumerations.MobStatType;
import io.github.thecsdev.betterstats.network.BetterStatsServerPlayNetworkHandler;
import io.github.thecsdev.betterstats.util.stats.StatAnnouncementSystem;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorServerPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerStatsCounter.class}, priority=-9000)
public abstract class MixinServerStatHandler
extends StatsCounter {
    @Inject(method={"setValue(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/stats/Stat;I)V"}, at={@At(value="HEAD")})
    public void onPreSetStat(Player player, Stat<?> stat, int value, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            StatAnnouncementSystem.__handleStatChange(sPlayer, stat, this.stats.getInt(stat), value);
        }
    }

    @Inject(method={"setValue(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/stats/Stat;I)V"}, at={@At(value="RETURN")})
    public void onSetStat(Player player, Stat<?> stat, int value, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if ((ItemStatType.isItemStat(stat) || MobStatType.isMobStat(stat)) && ((AccessorServerPlayer)serverPlayer).getServer().isRunning()) {
                BetterStatsServerPlayNetworkHandler.of(serverPlayer).sendLiveStatsAttepmt();
            }
        }
    }
}

