/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.network;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.client.network.BetterStatsClientPlayNetworkHandler;
import io.github.thecsdev.betterstats.network.BetterStatsServerPlayNetworkHandler;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.events.server.PlayerManagerEvent;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import java.util.function.Function;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BetterStatsNetwork {
    public static final Component TXT_TOGGLE_TOOLTIP = BST.net_toggleTooltip();
    public static final Component TXT_CONSENT_WARNING = BST.net_consentWarning();
    public static final int NETWORK_VERSION = 3;
    public static final ResourceLocation S2C_I_HAVE_BSS = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"s2c_bss");
    public static final ResourceLocation C2S_I_HAVE_BSS = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"c2s_bss");
    public static final ResourceLocation C2S_PREFERENCES = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"c2s_prf");
    public static final ResourceLocation C2S_MCBS_REQUEST = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"c2s_mcbs_req");
    public static final ResourceLocation S2C_MCBS = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"s2c_mcbs");

    private BetterStatsNetwork() {
    }

    public static void init() {
    }

    static {
        Function<Player, BetterStatsClientPlayNetworkHandler> c = player -> BetterStatsClientPlayNetworkHandler.of((LocalPlayer)player);
        Function<Player, BetterStatsServerPlayNetworkHandler> s = player -> BetterStatsServerPlayNetworkHandler.of((ServerPlayer)player);
        PlayerManagerEvent.PLAYER_CONNECTED.register(player -> ((BetterStatsServerPlayNetworkHandler)s.apply((Player)player)).onPlayerConnected());
        CustomPayloadNetwork.registerReciever((PacketFlow)PacketFlow.SERVERBOUND, (ResourceLocation)C2S_I_HAVE_BSS, ctx -> ((BetterStatsServerPlayNetworkHandler)s.apply(ctx.getPlayer())).onIHaveBss(ctx));
        CustomPayloadNetwork.registerReciever((PacketFlow)PacketFlow.SERVERBOUND, (ResourceLocation)C2S_PREFERENCES, ctx -> ((BetterStatsServerPlayNetworkHandler)s.apply(ctx.getPlayer())).onPreferences(ctx));
        CustomPayloadNetwork.registerReciever((PacketFlow)PacketFlow.SERVERBOUND, (ResourceLocation)C2S_MCBS_REQUEST, ctx -> ((BetterStatsServerPlayNetworkHandler)s.apply(ctx.getPlayer())).onMcbsRequest(ctx));
        if (BetterStats.isClient()) {
            CustomPayloadNetwork.registerReciever((PacketFlow)PacketFlow.CLIENTBOUND, (ResourceLocation)S2C_I_HAVE_BSS, ctx -> ((BetterStatsClientPlayNetworkHandler)c.apply(ctx.getPlayer())).onIHaveBss(ctx));
            CustomPayloadNetwork.registerReciever((PacketFlow)PacketFlow.CLIENTBOUND, (ResourceLocation)S2C_MCBS, ctx -> ((BetterStatsClientPlayNetworkHandler)c.apply(ctx.getPlayer())).onMcbs(ctx));
        }
    }
}

