/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.network;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.util.interfaces.IThirdPartyStatsListener;
import io.github.thecsdev.betterstats.api.util.io.ServerPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.network.BetterStatsNetwork;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorServerPlayer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BetterStatsServerPlayNetworkHandler {
    public static final ResourceLocation CUSTOM_DATA_ID = ResourceLocation.fromNamespaceAndPath((String)BetterStats.getModID(), (String)"server_play_network_handler");
    private final ServerPlayer player;
    private final MinecraftServer server;
    public boolean hasBssInstalled = false;
    public boolean netPref_enableLiveStats = false;
    public long liveStatsLastUpdate = 0L;
    public boolean netPref_statsSharingConsent = false;

    private BetterStatsServerPlayNetworkHandler(ServerPlayer player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.server = Objects.requireNonNull(((AccessorServerPlayer)player).getServer());
    }

    public final ServerPlayer getPlayer() {
        return this.player;
    }

    public final void onPlayerConnected() {
        this.sendIHaveBss();
    }

    public final void onIHaveBss(CustomPayloadNetworkReceiver.PacketContext ctx) {
        FriendlyByteBuf buffer = ctx.getPacketBuffer();
        if (buffer.readableBytes() == 0) {
            return;
        }
        int netVer = buffer.readIntLE();
        if (netVer != 3) {
            return;
        }
        this.hasBssInstalled = true;
    }

    public final void onPreferences(CustomPayloadNetworkReceiver.PacketContext ctx) {
        this.netPref_enableLiveStats = ctx.getPacketBuffer().readBoolean();
        this.netPref_statsSharingConsent = ctx.getPacketBuffer().readBoolean();
    }

    public final void onMcbsRequest(CustomPayloadNetworkReceiver.PacketContext ctx) {
        FriendlyByteBuf buffer = ctx.getPacketBuffer();
        switch (IThirdPartyStatsListener.TpslContext.Type.of(buffer.readInt())) {
            case SAME_SERVER_PLAYER: {
                String playerName = buffer.readUtf();
                ServerPlayer targetPlayer = this.server.getPlayerList().getPlayerByName(playerName);
                if (targetPlayer == null) {
                    this.sendNullPlayerMcbs(playerName);
                    return;
                }
                if (this.sendPlayerMcbs(targetPlayer, false)) break;
                this.sendNullPlayerMcbs(playerName);
                break;
            }
        }
    }

    public final void sendIHaveBss() {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeIntLE(3);
        CustomPayloadNetwork.sendS2C((ServerPlayer)this.player, (ResourceLocation)BetterStatsNetwork.S2C_I_HAVE_BSS, (ByteBuf)data);
    }

    public final boolean sendLiveStatsAttepmt() {
        if (!this.netPref_enableLiveStats) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.liveStatsLastUpdate < 300L) {
            return false;
        }
        this.liveStatsLastUpdate = currentTime;
        this.player.getStats().sendStats(this.player);
        return true;
    }

    public final boolean sendPlayerMcbs(ServerPlayer targetPlayer, boolean force) throws NullPointerException {
        Objects.requireNonNull(targetPlayer);
        if (!force && !BetterStatsServerPlayNetworkHandler.of((ServerPlayer)targetPlayer).netPref_statsSharingConsent) {
            return false;
        }
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER.getIntValue());
        data.writeUtf(targetPlayer.getName().getString());
        StatsProviderIO.write(data, ServerPlayerStatsProvider.of(targetPlayer));
        CustomPayloadNetwork.sendS2C((ServerPlayer)this.player, (ResourceLocation)BetterStatsNetwork.S2C_MCBS, (ByteBuf)data);
        return true;
    }

    public final void sendNullPlayerMcbs(String playerName) throws NullPointerException {
        Objects.requireNonNull(playerName);
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER_NOT_FOUND.getIntValue());
        data.writeUtf(playerName);
        CustomPayloadNetwork.sendS2C((ServerPlayer)this.player, (ResourceLocation)BetterStatsNetwork.S2C_MCBS, (ByteBuf)data);
    }

    public static final BetterStatsServerPlayNetworkHandler of(ServerPlayer player) throws NullPointerException {
        GenericProperties cd = EntityHooks.getCustomData((Entity)((Entity)Objects.requireNonNull(player)));
        @Nullable BetterStatsServerPlayNetworkHandler spnh = (BetterStatsServerPlayNetworkHandler)cd.getProperty((Object)CUSTOM_DATA_ID);
        if (spnh == null) {
            spnh = new BetterStatsServerPlayNetworkHandler(player);
            cd.setProperty((Object)CUSTOM_DATA_ID, (Object[])new BetterStatsServerPlayNetworkHandler[]{spnh});
        }
        return spnh;
    }
}

