/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.util.stats;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.BetterStatsProperties;
import io.github.thecsdev.betterstats.api.util.stats.SUGeneralStat;
import io.github.thecsdev.betterstats.network.BetterStatsServerPlayNetworkHandler;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.betterstats.util.stats.SASConfig;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorServerPlayer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class StatAnnouncementSystem {
    private static final Component WATERMARK;
    private static final BetterStatsConfig BSSC;
    private static final SASConfig SASC;
    public static final HashSet<Block> FIRST_MINED_BLOCKS;
    public static final HashSet<Item> FIRST_CRAFTED_ITEMS;
    public static final HashSet<EntityType<?>> FIRST_KILLED_ENTITIES;
    public static final HashSet<EntityType<?>> FIRST_KILLED_BY_ENTITIES;
    public static final HashSet<ResourceLocation> FIRST_CUSTOM_STATS;

    private StatAnnouncementSystem() {
    }

    @ApiStatus.Internal
    public static final void __handleStatChange(ServerPlayer player, Stat<?> stat, int oldValue, int newValue) throws NullPointerException {
        if (!StatAnnouncementSystem.BSSC.enableServerSAS) {
            return;
        }
        if (oldValue == 0 && newValue > 0) {
            Objects.requireNonNull(player);
            Objects.requireNonNull(stat);
            if (player.getAbilities().instabuild) {
                return;
            }
            if (stat.getType() == Stats.BLOCK_MINED && FIRST_MINED_BLOCKS.contains(stat.getValue())) {
                StatAnnouncementSystem.broadcastFirstMine(player, (Block)stat.getValue());
            } else if (stat.getType() == Stats.ITEM_CRAFTED && FIRST_CRAFTED_ITEMS.contains(stat.getValue())) {
                StatAnnouncementSystem.broadcastFirstCraft(player, (Item)stat.getValue());
            } else if (stat.getType() == Stats.ENTITY_KILLED && FIRST_KILLED_ENTITIES.contains(stat.getValue())) {
                StatAnnouncementSystem.broadcastFirstKilled(player, (EntityType)stat.getValue());
            } else if (stat.getType() == Stats.ENTITY_KILLED_BY && FIRST_KILLED_BY_ENTITIES.contains(stat.getValue())) {
                StatAnnouncementSystem.broadcastFirstKilledBy(player, (EntityType)stat.getValue());
            } else if (stat.getType() == Stats.CUSTOM && Objects.equals(stat.getValue(), Stats.DEATHS) && FIRST_CUSTOM_STATS.contains(stat.getValue())) {
                StatAnnouncementSystem.broadcastFirstDeath(player);
            } else if (stat.getType() == Stats.CUSTOM && FIRST_CUSTOM_STATS.contains(stat.getValue())) {
                Stat<?> cStat = stat;
                StatAnnouncementSystem.broadcastFirstCustomStat(player, cStat, stat.format(newValue));
            }
        }
    }

    private static final MutableComponent formatPlayerText(Player entity) {
        Objects.requireNonNull(entity);
        MutableComponent pText = TextUtils.literal((String)"").append(entity.getDisplayName()).withStyle(ChatFormatting.YELLOW);
        pText.setStyle(pText.getStyle().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TextUtils.literal((String)"").append(entity.getDisplayName()).append("\n").append((Component)TextUtils.literal((String)Objects.toString(entity.getUUID()).formatted(ChatFormatting.GRAY))))));
        return pText;
    }

    private static final MutableComponent formatBlockText(Block block) {
        Objects.requireNonNull(block);
        String blockId = Objects.toString(BuiltInRegistries.BLOCK.getKey((Object)block));
        MutableComponent bText = TextUtils.literal((String)"").append((Component)block.getName()).withStyle(ChatFormatting.GREEN);
        bText.setStyle(bText.getStyle().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TextUtils.literal((String)"").append((Component)block.getName()).append("\n").append((Component)TextUtils.literal((String)blockId).withStyle(ChatFormatting.GRAY)))));
        return bText;
    }

    private static final MutableComponent formatItemText(Item item) {
        Objects.requireNonNull(item);
        String itemId = Objects.toString(BuiltInRegistries.ITEM.getKey((Object)item));
        MutableComponent iText = TextUtils.literal((String)"").append(item.getName()).withStyle(ChatFormatting.GREEN);
        iText.setStyle(iText.getStyle().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TextUtils.literal((String)"").append(item.getName()).append("\n").append((Component)TextUtils.literal((String)itemId).withStyle(ChatFormatting.GRAY)))));
        return iText;
    }

    private static final MutableComponent formatEntityTypeText(EntityType<?> entityType) {
        Objects.requireNonNull(entityType);
        String entityTypeId = Objects.toString(BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
        MutableComponent pText = TextUtils.literal((String)"").append(entityType.getDescription()).withStyle(ChatFormatting.YELLOW);
        pText.setStyle(pText.getStyle().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TextUtils.literal((String)"").append(entityType.getDescription()).append("\n").append((Component)TextUtils.literal((String)entityTypeId).withStyle(ChatFormatting.GRAY)))));
        return pText;
    }

    public static final void broadcastFirstMine(ServerPlayer player, Block minedBlock) throws NullPointerException {
        MutableComponent pText = StatAnnouncementSystem.formatPlayerText((Player)player);
        MutableComponent bText = StatAnnouncementSystem.formatBlockText(minedBlock);
        StatAnnouncementSystem.broadcastBssMessage(((AccessorServerPlayer)player).getServer(), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)BST.sas_firstMine((Component)pText, (Component)bText)), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)pText).append(" just mined their first ").append((Component)bText).append("."));
    }

    public static final void broadcastFirstCraft(ServerPlayer player, Item craftedItem) throws NullPointerException {
        MutableComponent pText = StatAnnouncementSystem.formatPlayerText((Player)player);
        MutableComponent iText = StatAnnouncementSystem.formatItemText(craftedItem);
        StatAnnouncementSystem.broadcastBssMessage(((AccessorServerPlayer)player).getServer(), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)BST.sas_firstCraft((Component)pText, (Component)iText)), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)pText).append(" just crafted their first ").append((Component)iText).append("."));
    }

    public static final void broadcastFirstKilled(ServerPlayer player, EntityType<?> victimType) {
        MutableComponent pText = StatAnnouncementSystem.formatPlayerText((Player)player);
        MutableComponent etText = StatAnnouncementSystem.formatEntityTypeText(victimType);
        StatAnnouncementSystem.broadcastBssMessage(((AccessorServerPlayer)player).getServer(), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)BST.sas_firstKill((Component)pText, (Component)etText)), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)pText).append(" just killed a ").append((Component)etText).append(" for their first time."));
    }

    public static final void broadcastFirstKilledBy(ServerPlayer player, EntityType<?> killerType) {
        MutableComponent pText = StatAnnouncementSystem.formatPlayerText((Player)player);
        MutableComponent etText = StatAnnouncementSystem.formatEntityTypeText(killerType);
        StatAnnouncementSystem.broadcastBssMessage(((AccessorServerPlayer)player).getServer(), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)BST.sas_firstDeathTo((Component)pText, (Component)etText)), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)pText).append(" just died to a ").append((Component)etText).append(" for their first time."));
    }

    public static final void broadcastFirstDeath(ServerPlayer player) {
        boolean hardcore = ((AccessorServerPlayer)player).getServer().isHardcore();
        String literalBrightSide = hardcore ? " On the bright side, it likely won't happen again." : "";
        MutableComponent pText = StatAnnouncementSystem.formatPlayerText((Player)player);
        MutableComponent translatableText = hardcore ? BST.sas_firstDeath_hc1((Component)pText) : BST.sas_firstDeath((Component)pText);
        StatAnnouncementSystem.broadcastBssMessage(((AccessorServerPlayer)player).getServer(), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)translatableText), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)pText).append(" died for their first time." + literalBrightSide));
    }

    public static final void broadcastFirstCustomStat(ServerPlayer player, Stat<ResourceLocation> stat, String statValue) throws NullPointerException {
        MutableComponent pText = StatAnnouncementSystem.formatPlayerText((Player)player);
        MutableComponent sText = TextUtils.literal((String)"").append(SUGeneralStat.getGeneralStatText(stat)).withStyle(ChatFormatting.GRAY);
        MutableComponent vText = TextUtils.literal((String)statValue).withStyle(ChatFormatting.GREEN);
        StatAnnouncementSystem.broadcastBssMessage(((AccessorServerPlayer)player).getServer(), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)BST.sas_custom((Component)pText, (Component)sText, (Component)vText)), (Component)TextUtils.literal((String)"").append(WATERMARK).append(" ").append((Component)pText).append(" just increased their ").append((Component)sText).append(" stat value to ").append((Component)vText).append("."));
    }

    private static final void broadcastBssMessage(MinecraftServer server, Component withBssTranslations, Component allLiteral) throws NullPointerException {
        Objects.requireNonNull(server);
        Objects.requireNonNull(withBssTranslations);
        Objects.requireNonNull(allLiteral);
        if (TCDCommons.isClient() && server instanceof IntegratedServer && server.getPlayerCount() == 1) {
            server.getPlayerList().broadcastSystemMessage(withBssTranslations, false);
            return;
        }
        server.executeIfPossible(() -> server.getPlayerList().getPlayers().forEach(player -> {
            BetterStatsServerPlayNetworkHandler pp = BetterStatsServerPlayNetworkHandler.of(player);
            boolean hasBss = pp != null && pp.hasBssInstalled;
            Component msg = hasBss ? withBssTranslations : allLiteral;
            player.displayClientMessage(msg, false);
        }));
    }

    static {
        ResourceLocation id;
        if (!BetterStats.isModInitialized()) {
            throw new ExceptionInInitializerError("Attempted to initialize " + StatAnnouncementSystem.class.getSimpleName() + " prior to " + BetterStats.class.getSimpleName() + "'s initialization.");
        }
        BSSC = BetterStats.getInstance().getConfig();
        SASC = Objects.requireNonNull(StatAnnouncementSystem.BSSC.sasConfig, "SAS config didn't load properly. This shouldn't even happen..");
        MutableComponent hoverText = TextUtils.literal((String)BetterStats.getModName()).withStyle(ChatFormatting.YELLOW).append("\n").append((Component)TextUtils.literal((String)BetterStats.getModID()).withStyle(ChatFormatting.GRAY));
        HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)hoverText);
        ClickEvent.OpenUrl clickEvent = null;
        try {
            clickEvent = new ClickEvent.OpenUrl(new URI(BetterStatsProperties.URL_MODRINTH));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        MutableComponent text = TextUtils.literal((String)"[\u2261]").withStyle(ChatFormatting.DARK_PURPLE);
        text.setStyle(text.getStyle().withHoverEvent((HoverEvent)hoverEvent).withClickEvent((ClickEvent)clickEvent));
        WATERMARK = text;
        FIRST_MINED_BLOCKS = new HashSet();
        FIRST_CRAFTED_ITEMS = new HashSet();
        FIRST_KILLED_ENTITIES = new HashSet();
        FIRST_KILLED_BY_ENTITIES = new HashSet();
        FIRST_CUSTOM_STATS = new HashSet();
        for (String fmbId : StatAnnouncementSystem.SASC.firstMinedBlocks) {
            try {
                id = ResourceLocation.parse((String)fmbId);
                Block fmb = BuiltInRegistries.BLOCK.getOptional(id).orElse(null);
                if (fmb == null) continue;
                FIRST_MINED_BLOCKS.add(fmb);
            }
            catch (ResourceLocationException e) {
                // empty catch block
            }
        }
        for (String fciId : StatAnnouncementSystem.SASC.firstCraftedItems) {
            try {
                id = ResourceLocation.parse((String)fciId);
                Item fci = BuiltInRegistries.ITEM.getOptional(id).orElse(null);
                if (fci == null) continue;
                FIRST_CRAFTED_ITEMS.add(fci);
            }
            catch (ResourceLocationException e) {
                // empty catch block
            }
        }
        for (String fkeId : StatAnnouncementSystem.SASC.firstKilledEntities) {
            try {
                id = ResourceLocation.parse((String)fkeId);
                EntityType fke = BuiltInRegistries.ENTITY_TYPE.getOptional(id).orElse(null);
                if (fke == null) continue;
                FIRST_KILLED_ENTITIES.add(fke);
            }
            catch (ResourceLocationException e) {
                // empty catch block
            }
        }
        for (String fkbeId : StatAnnouncementSystem.SASC.firstKilledByEntities) {
            try {
                id = ResourceLocation.parse((String)fkbeId);
                EntityType fkbe = BuiltInRegistries.ENTITY_TYPE.getOptional(id).orElse(null);
                if (fkbe == null) continue;
                FIRST_KILLED_BY_ENTITIES.add(fkbe);
            }
            catch (ResourceLocationException e) {
                // empty catch block
            }
        }
        for (String fcsId : StatAnnouncementSystem.SASC.firstCustomStats) {
            try {
                id = ResourceLocation.parse((String)fcsId);
                ResourceLocation fcs = BuiltInRegistries.CUSTOM_STAT.getOptional(id).orElse(null);
                if (fcs == null) continue;
                FIRST_CUSTOM_STATS.add(fcs);
            }
            catch (ResourceLocationException e) {
                // empty catch block
            }
        }
    }
}

