/*
 * Decompiled with CFR 0.152.
 */
package com.deflanko.MCCFishingMessages;

import com.deflanko.MCCFishingMessages.FishingLocation;
import com.deflanko.MCCFishingMessages.FishingSpot;
import com.deflanko.MCCFishingMessages.MCCFishingMessagesMod;
import com.deflanko.MCCFishingMessages.config.Config;
import com.deflanko.MCCFishingMessages.config.ConfigManager;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class FishingChatBox {
    private static final int MAX_MESSAGES = 100;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;
    private static final int MESSAGE_HEIGHT = 9;
    private final class_310 client;
    private final Deque<ChatMessage> messages = new LinkedList<ChatMessage>();
    private int scrollOffset = 0;
    private boolean focused = false;
    private boolean visible = true;
    private boolean editMode = false;
    private EditState state = EditState.NONE;
    private int xDisplacement;
    private int yDisplacement;
    private int backupX;
    private int backupY;
    private int backupHeight;
    private int backupWidth;
    private final int minBoxWidth = 140;
    private final int minBoxHeight = 45;
    private int boxX;
    private int boxY;
    private int boxWidth;
    private int boxHeight;
    private float fontSize;
    private int guiScaleFactor = 1;
    private int maxVisibleMessages = 10;
    private int linesPerScroll;
    private boolean debug = false;
    private boolean macDisplay;
    private static final class_2561 COPY_ICON = class_2561.method_43470((String)"\ud83d\udccb");
    private static final int COPY_ICON_COLOR = -16720641;
    private final FishingLocation location = new FishingLocation();

    private static FishingSpot getPerks() {
        return FishingSpot.getCurrentFishingSpot();
    }

    public FishingChatBox(class_310 client, Config config) {
        this.client = client;
        this.boxX = config.boxX;
        this.boxY = config.boxY;
        this.boxHeight = config.boxHeight;
        this.boxWidth = config.boxWidth;
        this.fontSize = config.fontSize;
        this.linesPerScroll = config.scrollAmount;
        if (this.boxWidth < 140) {
            this.boxWidth = 140;
        }
        if (this.boxHeight < 45) {
            this.boxHeight = 45;
        }
        this.macDisplay = config.sillyMacDisplay;
        this.backupX = this.boxX;
        this.backupY = this.boxY;
        this.backupHeight = this.boxHeight;
        this.backupWidth = this.boxWidth;
    }

    public void render(class_332 context, double mouseX, double mouseY, class_9779 tickCounter) {
        int i;
        if (this.macDisplay) {
            mouseX *= 2.0;
            mouseY *= 2.0;
        }
        int scaledX = (int)(mouseX / (double)this.guiScaleFactor);
        int scaledY = (int)(mouseY / (double)this.guiScaleFactor);
        if (!this.visible || this.messages.isEmpty() || this.client.method_53526().method_53536()) {
            return;
        }
        context.method_25294(this.boxX, this.boxY, this.boxX + this.boxWidth, this.boxY + this.boxHeight, Integer.MIN_VALUE);
        if (this.focused && !this.client.field_1705.method_1743().method_1819()) {
            this.focused = false;
            this.scrollOffset = 0;
            if (this.state != EditState.NONE) {
                this.state = EditState.NONE;
                this.boxX = this.backupX;
                this.boxY = this.backupY;
                this.boxHeight = this.backupHeight;
                this.boxWidth = this.backupWidth;
            }
        }
        if (this.focused) {
            context.method_49601(this.boxX, this.boxY, this.boxWidth + 2, this.boxHeight + 2, -1);
        }
        String title = "Fishing Messages";
        assert (this.client.field_1724 != null);
        class_243 pos = this.client.field_1724.method_19538();
        String cords = "X: " + (int)pos.field_1352 + " Y: " + (int)pos.field_1351 + " Z: " + (int)pos.field_1350;
        if (this.boxWidth < this.client.field_1772.method_1727(cords) + 20 + this.client.field_1772.method_1727(title)) {
            title = "";
        }
        context.method_51433(this.client.field_1772, title, this.boxX + 5, this.boxY + 5, -1, true);
        int textX = this.boxX + this.boxWidth - this.client.field_1772.method_1727(cords) - 20;
        context.method_51433(this.client.field_1772, cords, textX, this.boxY + 5, -22016, true);
        int iconX = this.boxX + (this.boxWidth - 10);
        context.method_51439(this.client.field_1772, COPY_ICON, iconX, this.boxY + 5, -16720641, true);
        context.method_49601(this.boxX, this.boxY + 16, this.boxWidth, 1, -1);
        if (this.client.field_1705.method_1743().method_1819() && mouseX >= (double)(iconX * this.guiScaleFactor) && mouseX <= (double)(iconX * this.guiScaleFactor + this.client.field_1772.method_27525((class_5348)COPY_ICON)) && mouseY >= (double)((this.boxY + 5) * this.guiScaleFactor) && mouseY <= (double)((this.boxY + 5 + 9) * this.guiScaleFactor)) {
            context.method_25294(iconX, this.boxY + 5, iconX + this.client.field_1772.method_27525((class_5348)COPY_ICON), this.boxY + 14, -1426063361);
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.scale(this.fontSize, this.fontSize);
        int fontMarginWidth = (int)((float)this.boxWidth / this.fontSize) - 5;
        int yOffset = (int)((float)(this.boxY + this.boxHeight) / this.fontSize) - 9;
        int xOffset = (int)((float)this.boxX / this.fontSize);
        int visibleCount = 0;
        this.maxVisibleMessages = (int)((float)(this.boxHeight - 18) / this.fontSize) / 9;
        ArrayList<ChatMessage> visibleMessages = new ArrayList<ChatMessage>(this.messages);
        int startIndex = Math.max(0, Math.min(this.scrollOffset, this.messages.size() - this.maxVisibleMessages));
        ArrayList<class_5481> onScreenMessages = new ArrayList<class_5481>();
        for (i = startIndex; i < visibleMessages.size() && visibleCount < this.maxVisibleMessages; ++i) {
            ChatMessage message = (ChatMessage)visibleMessages.get(i);
            ArrayList wrappedText = new ArrayList(this.client.field_1772.method_1728((class_5348)message.chathudline.comp_893(), fontMarginWidth));
            FishingChatBox.reverseList(wrappedText);
            int localSize = 0;
            for (class_5481 line : wrappedText) {
                if (visibleCount >= this.maxVisibleMessages) continue;
                context.method_51430(this.client.field_1772, line, xOffset + 5, yOffset, -1, true);
                if (message.size < ++localSize) {
                    message.size = localSize;
                }
                yOffset -= 9;
                ++visibleCount;
                onScreenMessages.add(line);
            }
        }
        matrices.scale(1.0f / this.fontSize, 1.0f / this.fontSize);
        if (this.visible && this.client.field_1705.method_1743().method_1819() && this.MouseWithinBox(mouseX, mouseY)) {
            class_2583 style;
            int translatedMouseX;
            i = (int)Math.floor(mouseY / (double)this.guiScaleFactor) - this.boxY - 17 + (int)Math.floor(9.0f * this.fontSize / 2.0f);
            int lineIndex = (int)((float)i / this.fontSize) / 9;
            lineIndex -= this.maxVisibleMessages - Math.min(onScreenMessages.size(), this.maxVisibleMessages);
            --lineIndex;
            lineIndex = onScreenMessages.size() - 1 - lineIndex;
            if (lineIndex >= 0 && lineIndex < onScreenMessages.size() && (translatedMouseX = (int)Math.floor((mouseX / (double)this.guiScaleFactor - (double)this.boxX) / (double)this.fontSize)) > 0 && (style = this.client.field_1772.method_27527().method_30876((class_5481)onScreenMessages.get(lineIndex), translatedMouseX)) != null && style.method_10969() != null) {
                context.method_51441(this.client.field_1772, style, scaledX, scaledY);
            }
        }
        if (this.messages.size() > this.maxVisibleMessages) {
            int scrollBarHeight = this.boxHeight - 25;
            int thumbSize = Math.max(10, scrollBarHeight * this.maxVisibleMessages / this.messages.size());
            int thumbPosition = this.scrollOffset * (scrollBarHeight - thumbSize) / (this.messages.size() - this.maxVisibleMessages);
            context.method_25294(this.boxX + this.boxWidth - 5, this.boxY + 20, this.boxX + this.boxWidth - 2, this.boxY + this.boxHeight - 5, 0x40FFFFFF);
            context.method_25294(this.boxX + this.boxWidth - 5, this.boxY + this.boxHeight - 5 - thumbPosition, this.boxX + this.boxWidth - 2, this.boxY + this.boxHeight - 5 - thumbPosition - thumbSize, -5592406);
        }
        if (this.editMode) {
            context.method_25294(this.boxX, this.boxY, this.boxX + 10, this.boxY + 10, -16711936);
        }
        if (this.editMode && this.focused) {
            context.method_25294(this.boxX + 5, this.boxY + 2, this.boxX + this.boxWidth - 20, this.boxY + 17, -224);
            if (this.state == EditState.BOX) {
                this.boxX = Math.max((int)(mouseX / (double)this.guiScaleFactor) - this.xDisplacement, 0);
                this.boxY = Math.max((int)(mouseY / (double)this.guiScaleFactor) - this.yDisplacement, 0);
            }
            context.method_25294(this.boxX + this.boxWidth - 5, this.boxY + 10, this.boxX + this.boxWidth, this.boxY + this.boxHeight - 8, -57089);
            if (this.state == EditState.WIDTH) {
                this.boxWidth = Math.max((int)(mouseX / (double)this.guiScaleFactor), 140 + this.boxX) - this.boxX + 2;
            }
            context.method_25294(this.boxX + 3, this.boxY + this.boxHeight - 5, this.boxX + this.boxWidth - 3, this.boxY + this.boxHeight, -14614529);
            if (this.state == EditState.HEIGHT) {
                this.boxHeight = Math.max((int)(mouseY / (double)this.guiScaleFactor), 45 + this.boxY) - this.boxY + 2;
            }
        }
    }

    public static <T> void reverseList(List<T> list) {
        if (list.size() <= 1) {
            return;
        }
        T value = list.removeFirst();
        FishingChatBox.reverseList(list);
        list.add(value);
    }

    public void addMessage(class_2561 message, @Nullable class_7469 signatureData, @Nullable class_7591 indicator) {
        this.messages.addFirst(new ChatMessage(new class_303(this.client.field_1705.method_1738(), message, signatureData, indicator)));
        while (this.messages.size() > 100) {
            this.messages.removeLast();
        }
    }

    public boolean WithinBounds(double min, double value, double max) {
        return value > min && value < max;
    }

    public boolean MouseWithinBox(double mouseX, double mouseY) {
        return this.WithinBounds(this.boxX, mouseX / (double)this.guiScaleFactor, this.boxX + this.boxWidth) && this.WithinBounds(this.boxY, mouseY / (double)this.guiScaleFactor, this.boxY + this.boxHeight);
    }

    public void scroll(int amount) {
        amount *= this.linesPerScroll;
        if (this.focused) {
            this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset + amount), (int)0, (int)Math.max(0, this.messages.size() - this.maxVisibleMessages));
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        FishingSpot currentSpot;
        this.updateGuiScale();
        if (this.macDisplay) {
            mouseX *= 2.0;
            mouseY *= 2.0;
        }
        assert (this.client.field_1724 != null);
        this.location.updateLocation(this.client.field_1724.method_23317(), this.client.field_1724.method_23318(), this.client.field_1724.method_23321());
        int island = this.location.getIslandNumber();
        Object islandText = island > 0 ? "i" + island : "";
        Object cords = "";
        if (!((String)islandText).isEmpty()) {
            cords = (String)islandText + " ";
        }
        String perksText = (currentSpot = FishingChatBox.getPerks()) != null ? currentSpot.toString() : "";
        cords = (String)cords + " " + (int)this.client.field_1724.method_23317() + " " + (int)this.client.field_1724.method_23318() + " " + (int)this.client.field_1724.method_23321();
        if (!perksText.isEmpty()) {
            cords = (String)cords + " " + perksText;
        }
        int iconX = this.boxX + this.boxWidth - 10;
        if (button == 0 && this.WithinBounds(iconX, mouseX / (double)this.guiScaleFactor, iconX + this.client.field_1772.method_27525((class_5348)COPY_ICON)) && this.WithinBounds(this.boxY + 5, mouseY / (double)this.guiScaleFactor, this.boxY + 14)) {
            this.client.field_1774.method_1455((String)cords);
            MCCFishingMessagesMod.LOGGER.info("Copied coordinates to clipboard");
            return;
        }
        if (this.editMode && this.focused && button == 0) {
            if (this.WithinBounds(this.boxX + 5, mouseX / (double)this.guiScaleFactor, this.boxX + this.boxWidth - 20) && this.WithinBounds(this.boxY + 2, mouseY / (double)this.guiScaleFactor, this.boxY + 17)) {
                if (this.state == EditState.BOX) {
                    this.EndEdit();
                } else {
                    this.xDisplacement = (int)(mouseX / (double)this.guiScaleFactor) - this.boxX;
                    this.yDisplacement = (int)(mouseY / (double)this.guiScaleFactor) - this.boxY;
                    this.backupX = this.boxX;
                    this.backupY = this.boxY;
                    this.state = EditState.BOX;
                }
            } else if (this.WithinBounds(this.boxX + this.boxWidth - 5, mouseX / (double)this.guiScaleFactor, this.boxX + this.boxWidth) && this.WithinBounds(this.boxY + 10, mouseY / (double)this.guiScaleFactor, this.boxY + this.boxHeight - 8)) {
                if (this.state == EditState.WIDTH) {
                    this.EndEdit();
                } else {
                    this.backupWidth = this.boxWidth;
                    this.state = EditState.WIDTH;
                }
            } else if (this.WithinBounds(this.boxX + 3, mouseX / (double)this.guiScaleFactor, this.boxX + this.boxWidth - 3) && this.WithinBounds(this.boxY + this.boxHeight - 5, mouseY / (double)this.guiScaleFactor, this.boxY + this.boxHeight)) {
                if (this.state == EditState.HEIGHT) {
                    this.EndEdit();
                } else {
                    this.backupHeight = this.boxHeight;
                    this.state = EditState.HEIGHT;
                }
            }
        }
        boolean bl = this.focused = this.visible && this.MouseWithinBox(mouseX, mouseY) && button == 0 && this.client.field_1705.method_1743().method_1819();
        if (!this.focused) {
            this.scrollOffset = 0;
            this.state = EditState.NONE;
        }
    }

    public void Save() {
        ConfigManager.instance().SetNewValues(this.boxX, this.boxWidth, this.boxY, this.boxHeight, this.fontSize);
    }

    public void EndEdit() {
        this.state = EditState.NONE;
        this.Save();
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void changeFontSize(float changeAmt) {
        float i = this.fontSize;
        this.fontSize = Math.max(0.2f, Math.min(1.5f, i + changeAmt));
        this.Save();
    }

    public void ToggleEditMode() {
        boolean bl = this.editMode = !this.editMode;
        if (this.state != EditState.NONE) {
            this.state = EditState.NONE;
            this.boxX = this.backupX;
            this.boxY = this.backupY;
            this.boxHeight = this.backupHeight;
            this.boxWidth = this.backupWidth;
        }
    }

    public void ToggleDebug() {
        this.debug = !this.debug;
    }

    public void updateGuiScale() {
        this.guiScaleFactor = (Integer)this.client.field_1690.method_42474().method_41753();
    }

    @Environment(value=EnvType.CLIENT)
    private static enum EditState {
        NONE,
        BOX,
        WIDTH,
        HEIGHT;

    }

    @Environment(value=EnvType.CLIENT)
    private static class ChatMessage {
        public class_303 chathudline;
        public int size;

        public ChatMessage(class_303 text) {
            this.chathudline = text;
            this.size = 0;
        }
    }
}

