/*
 * Decompiled with CFR 0.152.
 */
package com.deflanko.MCCFishingMessages;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8113;

@Environment(value=EnvType.CLIENT)
public class FishingSpot {
    private static boolean isFishing = false;
    private static int waitTime = 0;
    private static FishingSpot currentFishingSpot = null;
    private final String location;
    private final List<String> perks;
    private final class_8113.class_8123 entity;

    public static FishingSpot getCurrentFishingSpot() {
        return currentFishingSpot;
    }

    public List<String> getPerks() {
        return this.perks;
    }

    public String getLocation() {
        return this.location;
    }

    public FishingSpot(String location, List<String> perks, class_8113.class_8123 entity) {
        this.location = location;
        this.perks = perks;
        this.entity = entity;
    }

    public class_8113.class_8123 getEntity() {
        return this.entity;
    }

    public static void checkFishing() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1536 fishHook = player.field_7513;
        if (fishHook == null) {
            if (isFishing) {
                isFishing = false;
            }
            return;
        }
        if (fishHook.method_52535() && !isFishing) {
            isFishing = true;
            waitTime = 0;
            FishingSpot.getFishingSpot((class_1657)player, fishHook);
        }
    }

    private static void getFishingSpot(class_1657 player, class_1536 fishHook) {
        class_2338 blockPos = fishHook.method_24515();
        class_238 box = class_238.method_30048((class_243)blockPos.method_46558(), (double)3.5, (double)6.0, (double)3.5);
        List<class_1297> entities = player.method_37908().method_8335(null, box).stream().filter(entity -> entity instanceof class_8113.class_8123).toList();
        if (!entities.isEmpty()) {
            class_8113.class_8123 textDisplay = (class_8113.class_8123)entities.getFirst();
            if (currentFishingSpot != null && currentFishingSpot.getEntity().equals((Object)textDisplay)) {
                return;
            }
            String text = textDisplay.method_48915().getString();
            System.out.println("Raw text from display: [" + text + "]");
            int fishingSpotX = textDisplay.method_31477();
            int fishingSpotY = textDisplay.method_31478();
            int fishingSpotZ = textDisplay.method_31479();
            String location = String.format("%d %d %d", fishingSpotX, fishingSpotY, fishingSpotZ);
            List<String> perks = Arrays.stream(text.split("\n")).map(String::trim).filter(line -> line.contains("+")).map(line -> line.replaceAll("[^\\x20-\\x7E]", "")).toList();
            System.out.println("Parsed location: " + location);
            System.out.println("Parsed perks: " + String.valueOf(perks));
            if (!perks.isEmpty()) {
                currentFishingSpot = new FishingSpot(location, perks, textDisplay);
                String formattedPerks = String.join((CharSequence)", ", perks);
                System.out.println("Formatted perks for clipboard: " + formattedPerks);
            }
        }
    }

    public String toString() {
        String perksText = this.perks != null ? String.join((CharSequence)", ", this.perks) : "none";
        return perksText;
    }
}

