/*
 * Decompiled with CFR 0.152.
 */
package com.deflanko.MCCFishingMessages;

import com.deflanko.MCCFishingMessages.FishingChatBox;
import com.deflanko.MCCFishingMessages.FishingSpot;
import com.deflanko.MCCFishingMessages.InputHandler;
import com.deflanko.MCCFishingMessages.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7591;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class MCCFishingMessagesMod
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mcc-fishing-messages");
    public static final class_310 CLIENT = class_310.method_1551();
    public static FishingChatBox fishingChatBox;
    public static final String MODID = "mccfishingmessages";
    private static List<String> pulledPhrases;
    private static List<String> blockedPhrases;

    public void onInitializeClient() {
        LOGGER.info("MCC Island Fishing Chat Filter initialized");
        ConfigManager.init();
        ConfigManager.loadWithFailureBackup();
        this.setWordLists();
        fishingChatBox = new FishingChatBox(CLIENT, ConfigManager.instance());
        InputHandler.init();
        HudRenderCallback.EVENT.register((matrices, tickDelta) -> {
            if (MCCFishingMessagesMod.CLIENT.field_1724 != null && MCCFishingMessagesMod.isOnMCCIsland()) {
                fishingChatBox.render(matrices, MCCFishingMessagesMod.CLIENT.field_1729.method_1603(), MCCFishingMessagesMod.CLIENT.field_1729.method_1604(), tickDelta);
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, a) -> {
            if (!MCCFishingMessagesMod.isOnMCCIsland()) {
                return true;
            }
            if (MCCFishingMessagesMod.isBlockedPhrase(message)) {
                return false;
            }
            if (MCCFishingMessagesMod.isPulledPhrase(message)) {
                fishingChatBox.addMessage(message, null, class_7591.method_44751());
                return !fishingChatBox.isVisible();
            }
            return true;
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                FishingSpot.checkFishing();
            }
        });
    }

    public static boolean isOnMCCIsland() {
        return CLIENT.method_1558() != null && MCCFishingMessagesMod.CLIENT.method_1558().field_3761.contains("mccisland.net");
    }

    public static boolean isPulledPhrase(class_2561 message) {
        String text = message.getString().toLowerCase();
        boolean caught = false;
        for (String line : pulledPhrases) {
            if (!text.contains(line)) continue;
            caught = true;
            break;
        }
        return caught;
    }

    public static boolean isBlockedPhrase(class_2561 message) {
        if (blockedPhrases.isEmpty()) {
            return false;
        }
        String text = message.getString().toLowerCase();
        boolean caught = false;
        for (String line : blockedPhrases) {
            if (!text.contains(line)) continue;
            caught = true;
            break;
        }
        return caught;
    }

    private void setWordLists() {
        pulledPhrases = ConfigManager.instance().pulledPhrases;
        blockedPhrases = ConfigManager.instance().blockedPhrases;
    }

    static {
        pulledPhrases = new ArrayList<String>();
        blockedPhrases = new ArrayList<String>();
    }
}

