/*
 * Decompiled with CFR 0.152.
 */
package com.deflanko.MCCFishingMessages.config;

import com.deflanko.MCCFishingMessages.MCCFishingMessagesMod;
import com.deflanko.MCCFishingMessages.config.Config;
import com.google.gson.FieldNamingPolicy;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("mccfishingmessages.json");
    public static final class_2960 CONFIG_ID = class_2960.method_60655((String)"mccfishingmessages", (String)"mccfishingmessages");
    private static ConfigClassHandler<Config> config;

    public static ConfigClassHandler<Config> handler() {
        if (config == null) {
            throw new IllegalStateException("Config accessed before it was initialized");
        }
        return config;
    }

    public static Config instance() {
        if (config == null) {
            throw new IllegalStateException("Config accessed before it was initialized");
        }
        return (Config)config.instance();
    }

    public static boolean isInitialized() {
        return config != null;
    }

    public static void init() {
        if (ConfigManager.isInitialized()) {
            return;
        }
        ConfigManager.config = ConfigClassHandler.createBuilder(Config.class).id(CONFIG_ID).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(b -> b.serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().registerTypeAdapter(Config.class, Config.INSTANCE_CREATOR)).setPath(CONFIG_PATH).setJson5(false).build()).build();
    }

    public static void saveConfig() {
        assert (config != null);
        try {
            config.save();
        }
        catch (Exception e) {
            MCCFishingMessagesMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void loadWithFailureBackup() {
        assert (config != null);
        try {
            config.load();
            return;
        }
        catch (Exception e) {
            MCCFishingMessagesMod.LOGGER.error("Failed to load config", (Throwable)e);
            File file = CONFIG_PATH.toFile();
            if (file.exists() && file.isFile()) {
                String backupName = FilenameUtils.getBaseName((String)file.getName()) + "-backup-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + FilenameUtils.getExtension((String)file.getName());
                Path backup = Path.of(CONFIG_PATH.toAbsolutePath().getParent().toString(), backupName);
                try {
                    Files.copy(file.toPath(), backup, StandardCopyOption.REPLACE_EXISTING);
                    MCCFishingMessagesMod.LOGGER.info("Created config backup at: {}", (Object)backup);
                }
                catch (Exception backupException) {
                    MCCFishingMessagesMod.LOGGER.error("Failed to create config backup: ", (Throwable)backupException);
                }
            } else if (file.exists() && file.delete()) {
                MCCFishingMessagesMod.LOGGER.info("Deleted old config");
            }
            try {
                config.save();
                MCCFishingMessagesMod.LOGGER.info("Created new config");
                config.load();
            }
            catch (Exception loadException) {
                MCCFishingMessagesMod.LOGGER.error("Failed to load config again, please report this issue: ", (Throwable)loadException);
            }
            return;
        }
    }
}

