/*
 * Decompiled with CFR 0.152.
 */
package com.deflanko.MCCFishingMessages;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FishingLocation {
    private int islandNumber = 0;
    private final List<IslandBoundary> islands = Arrays.asList(new IslandBoundary(1, -470.0, -50.0, 30.0, -50.0, 250.0, 460.0), new IslandBoundary(2, 1630.0, -50.0, 570.0, 2000.0, 250.0, 928.0), new IslandBoundary(3, 1589.0, -50.0, 1626.0, 1976.0, 250.0, 1983.0), new IslandBoundary(4, 596.0, -50.0, 1532.0, 952.0, 250.0, 1982.0), new IslandBoundary(5, -488.0, -50.0, 1633.0, -72.0, 250.0, 2023.0), new IslandBoundary(6, 1570.0, -50.0, -406.0, 1982.0, 250.0, -60.0), new IslandBoundary(7, 2560.0, -50.0, -484.0, 3100.0, 250.0, -10.0), new IslandBoundary(8, 2680.0, -50.0, 1110.0, 2960.0, 250.0, 1460.0), new IslandBoundary(9, 1050.0, -50.0, 2570.0, 1510.0, 250.0, 3080.0));

    public void updateLocation(double x, double y, double z) {
        for (IslandBoundary island : this.islands) {
            if (!island.contains(x, y, z)) continue;
            this.islandNumber = island.number;
            return;
        }
        this.islandNumber = 0;
    }

    public int getIslandNumber() {
        return this.islandNumber;
    }

    @Environment(value=EnvType.CLIENT)
    private static class IslandBoundary {
        final int number;
        final double minX;
        final double minY;
        final double maxX;
        final double maxY;
        final double minZ;
        final double maxZ;

        IslandBoundary(int number, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.number = number;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        boolean contains(double x, double y, double z) {
            return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
        }
    }
}

