/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util.maze_world.types;

import io.netty.util.collection.ByteObjectHashMap;
import io.netty.util.collection.ByteObjectMap;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.soulsandman.contentified.util.maze_world.MazeChunkGeneratorConfig;
import net.soulsandman.contentified.util.maze_world.MazeGenerator2D;
import net.soulsandman.contentified.util.maze_world.Tile;

public abstract class WangTilesMazeGenerator
extends MazeGenerator2D {
    private final ByteObjectMap<Tile> tilesByWalls = new ByteObjectHashMap();
    private final List<Tile> determinableTiles = new ArrayList<Tile>();

    public WangTilesMazeGenerator(MazeChunkGeneratorConfig config) {
        super(config);
        this.registerTiles();
    }

    public void register(Tile tile) {
        this.tilesByWalls.put(tile.wallState, (Object)tile);
        this.determinableTiles.add(tile);
    }

    public void registerIndeterminable(Tile tile) {
        this.tilesByWalls.put(tile.wallState, (Object)tile);
    }

    public void register4(Tile tile) {
        for (int i = 0; i < 4; ++i) {
            this.register(tile.rotated(i));
        }
    }

    protected abstract void registerTiles();

    @Override
    public MazeGenerator2D.BlockChecker2D getBlockChecker(long worldSeed) {
        int spacing = this.config.spacing;
        LongObjectHashMap tileCache = new LongObjectHashMap();
        return (arg_0, arg_1) -> this.lambda$getBlockChecker$0(spacing, worldSeed, (LongObjectMap)tileCache, arg_0, arg_1);
    }

    private Tile computeTileAt(int tx, int tz, long worldSeed, LongObjectMap<Tile> tileCache) {
        long pos = Tile.tilePosToLong(tx, tz);
        Tile tile = (Tile)tileCache.get(pos);
        if (tile == null) {
            tile = this.computeTileAt(tx, tz, worldSeed);
            tileCache.put(pos, (Object)tile);
        }
        return tile;
    }

    private Tile computeTileAt(int tx, int tz, long worldSeed) {
        if (this.isDeterminedTile(tx, tz)) {
            return this.getDeterminedTile(tx, tz, worldSeed);
        }
        byte centerWallState = 0;
        centerWallState = (byte)(centerWallState | (this.getDeterminedTile((int)tx, (int)(tz - 1), (long)worldSeed).wallState & 2) << 2);
        centerWallState = (byte)(centerWallState | (this.getDeterminedTile((int)(tx + 1), (int)tz, (long)worldSeed).wallState & 1) << 2);
        centerWallState = (byte)(centerWallState | (this.getDeterminedTile((int)tx, (int)(tz + 1), (long)worldSeed).wallState & 8) >> 2);
        centerWallState = (byte)(centerWallState | (this.getDeterminedTile((int)(tx - 1), (int)tz, (long)worldSeed).wallState & 4) >> 2);
        return (Tile)this.tilesByWalls.get(centerWallState);
    }

    private Tile getDeterminedTile(int tx, int tz, long worldSeed) {
        return this.determinableTiles.get(WangTilesMazeGenerator.getRandomIntAt(tx, tz, worldSeed, this.determinableTiles.size()));
    }

    private boolean isDeterminedTile(int tx, int tz) {
        return (tx + tz) % 2 == 0;
    }

    private /* synthetic */ boolean lambda$getBlockChecker$0(int spacing, long worldSeed, LongObjectMap tileCache, int x, int z) {
        int tx = Math.floorDiv(x, spacing);
        int tz = Math.floorDiv(z, spacing);
        Tile tile = this.computeTileAt(tx, tz, worldSeed, (LongObjectMap<Tile>)tileCache);
        double tilePosX = (double)Math.floorMod(x, spacing) / (double)spacing;
        double tilePosY = (double)Math.floorMod(z, spacing) / (double)spacing;
        return tile.isBlock(tilePosX, tilePosY);
    }
}

