/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.soulsandman.contentified.command.custom.EntityNavigatorTracker;

public class PathfindCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pathfind").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9247((String)"pos").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.05f, (float)2.0f)).executes(ctx -> {
            Collection entities = class_2186.method_9317((CommandContext)ctx, (String)"targets");
            class_243 pos = class_2277.method_9736((CommandContext)ctx, (String)"pos");
            float speed = FloatArgumentType.getFloat((CommandContext)ctx, (String)"speed");
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            int count = PathfindCommand.startPathfindingToPosition(world, entities, pos, speed, (class_2168)ctx.getSource());
            PathfindCommand.sendResult((class_2168)ctx.getSource(), count);
            return count;
        }))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"targetEntity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.05f, (float)2.0f)).executes(ctx -> {
            Collection entities = class_2186.method_9317((CommandContext)ctx, (String)"targets");
            class_1297 targetEntity = class_2186.method_9313((CommandContext)ctx, (String)"targetEntity");
            float speed = FloatArgumentType.getFloat((CommandContext)ctx, (String)"speed");
            class_3218 world = ((class_2168)ctx.getSource()).method_9225();
            class_243 pos = targetEntity.method_73189();
            int count = PathfindCommand.startPathfindingToPosition(world, entities, pos, speed, (class_2168)ctx.getSource());
            PathfindCommand.sendResult((class_2168)ctx.getSource(), count);
            return count;
        })))))));
    }

    private static int startPathfindingToPosition(class_3218 world, Collection<? extends class_1297> entities, class_243 pos, float speed, class_2168 source) {
        int count = 0;
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1314)) continue;
            class_1314 pathAware = (class_1314)class_12972;
            EntityNavigatorTracker.startTracking(world.method_8503(), pathAware, pos, speed, source);
            ++count;
        }
        return count;
    }

    private static void sendResult(class_2168 source, int count) {
        if (count == 0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No valid PathAwareEntities selected."));
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Pathfinding started for " + count + " entit" + (count > 1 ? "ies" : "y") + ".")), false);
        }
    }
}

