/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_9334;

public class RenameCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"name", (ArgumentType)class_2196.method_9340()).executes(ctx -> RenameCommand.renameItem((CommandContext<class_2168>)ctx, RenameMode.SET))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)class_2196.method_9340()).executes(ctx -> RenameCommand.renameItem((CommandContext<class_2168>)ctx, RenameMode.ADD_AFTER))))).then(class_2170.method_9247((String)"slip").then(class_2170.method_9244((String)"name", (ArgumentType)class_2196.method_9340()).executes(ctx -> RenameCommand.renameItem((CommandContext<class_2168>)ctx, RenameMode.ADD_BEFORE))))).then(class_2170.method_9247((String)"center").then(class_2170.method_9244((String)"name", (ArgumentType)class_2196.method_9340()).executes(ctx -> RenameCommand.renameItem((CommandContext<class_2168>)ctx, RenameMode.ADD_CENTER))))).then(class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (class_124 formatting : class_124.values()) {
                if (!formatting.method_543()) continue;
                builder.suggest(formatting.method_537());
            }
            return builder.buildFuture();
        }).executes(RenameCommand::setColor)))).then(class_2170.method_9247((String)"uppercase").executes(ctx -> RenameCommand.renameItem((CommandContext<class_2168>)ctx, RenameMode.UPPERCASE)))).then(class_2170.method_9247((String)"lowercase").executes(ctx -> RenameCommand.renameItem((CommandContext<class_2168>)ctx, RenameMode.LOWERCASE)))).then(class_2170.method_9247((String)"remove").executes(RenameCommand::removeName))).then(class_2170.method_9247((String)"bold").then(class_2170.method_9244((String)"is_bold", (ArgumentType)BoolArgumentType.bool()).executes(RenameCommand::setBold)))).then(class_2170.method_9247((String)"italic").then(class_2170.method_9244((String)"is_italic", (ArgumentType)BoolArgumentType.bool()).executes(RenameCommand::setItalic)))).then(class_2170.method_9247((String)"strikethrough").then(class_2170.method_9244((String)"is_strikethrough", (ArgumentType)BoolArgumentType.bool()).executes(RenameCommand::setStrikethrough)))).then(class_2170.method_9247((String)"obfuscated").then(class_2170.method_9244((String)"is_obfuscated", (ArgumentType)BoolArgumentType.bool()).executes(RenameCommand::setObfuscated)))));
    }

    private static int renameItem(CommandContext<class_2168> context, RenameMode mode) throws CommandSyntaxException {
        class_1799 item = ((class_2168)context.getSource()).method_44023().method_6047();
        if (item.method_7960()) {
            RenameCommand.sendError(context, "You must hold an item.");
            return 0;
        }
        class_2561 baseName = (class_2561)item.method_58694(class_9334.field_49631);
        if (baseName == null) {
            baseName = item.method_7964();
        }
        class_5250 currentName = baseName.method_27662();
        String input = null;
        if (mode == RenameMode.SET || mode == RenameMode.ADD_AFTER || mode == RenameMode.ADD_BEFORE || mode == RenameMode.ADD_CENTER) {
            input = class_2196.method_9339(context, (String)"name").getString();
        }
        switch (mode.ordinal()) {
            case 0: {
                RenameCommand.setName(item, (class_2561)class_2561.method_43470((String)input));
                RenameCommand.sendSuccess(context, "Set custom item name to: \"" + input + "\"");
                break;
            }
            case 1: {
                RenameCommand.setName(item, (class_2561)class_2561.method_43470((String)(currentName.getString() + input)));
                RenameCommand.sendSuccess(context, "Added text after name: \"" + input + "\"");
                break;
            }
            case 2: {
                RenameCommand.setName(item, (class_2561)class_2561.method_43470((String)(input + currentName.getString())));
                RenameCommand.sendSuccess(context, "Added text before name: \"" + input + "\"");
                break;
            }
            case 3: {
                String original = currentName.getString();
                int mid = original.length() / 2;
                String centered = original.substring(0, mid) + input + original.substring(mid);
                RenameCommand.setName(item, (class_2561)class_2561.method_43470((String)centered));
                RenameCommand.sendSuccess(context, "Inserted text in center: \"" + input + "\"");
                break;
            }
            case 4: {
                RenameCommand.setName(item, (class_2561)class_2561.method_43470((String)currentName.getString().toUpperCase()));
                RenameCommand.sendSuccess(context, "Converted item name to uppercase");
                break;
            }
            case 5: {
                RenameCommand.setName(item, (class_2561)class_2561.method_43470((String)currentName.getString().toLowerCase()));
                RenameCommand.sendSuccess(context, "Converted item name to lowercase");
            }
        }
        return 1;
    }

    private static int removeName(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1799 item = ((class_2168)context.getSource()).method_44023().method_6047();
        if (item.method_7960() || item.method_58694(class_9334.field_49631) == null) {
            return RenameCommand.noCustomName(context);
        }
        item.method_57381(class_9334.field_49631);
        RenameCommand.sendSuccess(context, "Removed custom item name.");
        return 1;
    }

    private static int setBold(CommandContext<class_2168> context) throws CommandSyntaxException {
        return RenameCommand.applyStyleFlag(context, "is_bold", StyleFlag.BOLD);
    }

    private static int setStrikethrough(CommandContext<class_2168> context) throws CommandSyntaxException {
        return RenameCommand.applyStyleFlag(context, "is_strikethrough", StyleFlag.STRIKETHROUGH);
    }

    private static int setObfuscated(CommandContext<class_2168> context) throws CommandSyntaxException {
        return RenameCommand.applyStyleFlag(context, "is_obfuscated", StyleFlag.OBFUSCATED);
    }

    private static int setItalic(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1799 item = ((class_2168)context.getSource()).method_44023().method_6047();
        if (item.method_7960()) {
            RenameCommand.sendError(context, "You must hold an item.");
            return 0;
        }
        boolean italic = BoolArgumentType.getBool(context, (String)"is_italic");
        RenameCommand.updateItemNameStyle(item, style -> style.method_10978(Boolean.valueOf(italic)));
        RenameCommand.sendSuccess(context, "Toggled italic: " + italic);
        return 1;
    }

    private static int setColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1799 item = ((class_2168)context.getSource()).method_44023().method_6047();
        if (item.method_7960()) {
            RenameCommand.sendError(context, "You must hold an item.");
            return 0;
        }
        String colorArg = StringArgumentType.getString(context, (String)"color");
        class_5251 textColor = null;
        class_124 formatting = class_124.method_533((String)colorArg.toLowerCase());
        if (formatting != null && formatting.method_543()) {
            textColor = class_5251.method_27718((class_124)formatting);
        } else {
            Object candidate = colorArg.startsWith("#") ? colorArg : "#" + colorArg;
            DataResult result = class_5251.method_27719((String)candidate);
            textColor = result.result().orElse(null);
        }
        if (textColor == null) {
            RenameCommand.sendError(context, "Invalid color: " + colorArg + ". Use a named or hex color.");
            return 0;
        }
        class_5251 finalTextColor = textColor;
        RenameCommand.updateItemNameStyle(item, style -> style.method_27703(finalTextColor));
        RenameCommand.sendSuccess(context, "Set item name color to: " + colorArg);
        return 1;
    }

    private static void updateItemNameStyle(class_1799 item, UnaryOperator<class_2583> styleUpdater) {
        class_2561 baseName = (class_2561)item.method_58694(class_9334.field_49631);
        if (baseName == null) {
            baseName = item.method_7964();
        }
        class_5250 name = baseName.method_27661();
        class_2583 existing = name.method_10866();
        class_2583 updated = (class_2583)styleUpdater.apply(existing);
        name.method_10862(updated);
        item.method_57379(class_9334.field_49631, (Object)name);
    }

    private static void setName(class_1799 item, class_2561 name) {
        item.method_57379(class_9334.field_49631, (Object)name);
    }

    private static void sendSuccess(CommandContext<class_2168> ctx, String msg) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)msg).method_27692(class_124.field_1068), false);
    }

    private static void sendError(CommandContext<class_2168> ctx, String msg) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)msg).method_27692(class_124.field_1061), false);
    }

    private static int noCustomName(CommandContext<class_2168> ctx) {
        RenameCommand.sendError(ctx, "Item must have a custom name first.");
        return 0;
    }

    private static int applyStyleFlag(CommandContext<class_2168> context, String argName, StyleFlag flag) throws CommandSyntaxException {
        class_1799 item = ((class_2168)context.getSource()).method_44023().method_6047();
        if (item.method_7960()) {
            RenameCommand.sendError(context, "You must hold an item.");
            return 0;
        }
        boolean value = BoolArgumentType.getBool(context, (String)argName);
        RenameCommand.updateItemNameStyle(item, style -> switch (flag.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> style.method_10982(Boolean.valueOf(value));
            case 1 -> style.method_36140(Boolean.valueOf(value));
            case 2 -> style.method_36141(Boolean.valueOf(value));
            case 3 -> style.method_10978(Boolean.valueOf(value));
        });
        RenameCommand.sendSuccess(context, "Set " + flag.name().toLowerCase() + " to " + value);
        return 1;
    }

    private static enum RenameMode {
        SET,
        ADD_AFTER,
        ADD_BEFORE,
        ADD_CENTER,
        UPPERCASE,
        LOWERCASE;

    }

    private static enum StyleFlag {
        BOLD,
        STRIKETHROUGH,
        OBFUSCATED,
        ITALIC;

    }
}

