/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1480;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3612;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_9817;
import net.soulsandman.contentified.item.ModItems;
import net.soulsandman.contentified.sound.ModSounds;

public class LoonEntity
extends class_1480
implements class_5761,
class_9817 {
    public final class_7094 divingAnimationState = new class_7094();
    private int divingAnimationTimeout = 0;
    private static final int DIVE_DURATION_TICKS = 60;
    private static final int DIVE_COOLDOWN_TICKS = 200;
    private int diveCooldown = 0;
    private int fishSpawnDelay = -1;
    private static final int FISH_SPAWN_DELAY_TICKS = 20;
    private static final class_2940<Boolean> IS_DIVING = class_2945.method_12791(LoonEntity.class, (class_2941)class_2943.field_13323);
    private static final double FIXED_WATER_Y_OFFSET = 0.8;

    public LoonEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_14, 8.0f);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_DIVING, (Object)false);
    }

    public boolean isDiving() {
        return (Boolean)this.field_6011.method_12789(IS_DIVING);
    }

    public static class_5132.class_5133 createLoonAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 15.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new FindWaterGoal((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new WaterWanderGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this).orElse(super.method_5992(player, hand));
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().field_9236) {
            if (this.isDiving()) {
                if (!this.divingAnimationState.method_41327()) {
                    this.divingAnimationState.method_41322(this.field_6012);
                }
            } else if (this.divingAnimationState.method_41327()) {
                this.divingAnimationState.method_41325();
            }
        }
        if (!this.method_73183().field_9236) {
            if (this.isDiving()) {
                if (this.divingAnimationTimeout > 0) {
                    --this.divingAnimationTimeout;
                } else {
                    this.field_6011.method_12778(IS_DIVING, (Object)false);
                    this.diveCooldown = 200;
                    this.fishSpawnDelay = -1;
                }
                if (this.fishSpawnDelay > 0) {
                    --this.fishSpawnDelay;
                } else if (this.fishSpawnDelay == 0) {
                    List<class_1799> itemStacks = List.of(class_1802.field_8429.method_7854(), class_1802.field_8209.method_7854(), class_1802.field_8323.method_7854(), class_1802.field_8846.method_7854());
                    int fishRandom = class_5819.method_43047().method_39332(0, 3);
                    class_1799 item = itemStacks.get(fishRandom);
                    this.method_73183().method_8649((class_1297)new class_1542(this.method_73183(), this.method_23317(), this.method_23318() + 0.25, this.method_23321(), item));
                    for (int i = 0; i < 7; ++i) {
                        this.method_73183().method_8406((class_2394)class_2398.field_11202, this.method_73189().field_1352, this.method_73189().field_1351 + 0.25, this.method_73189().field_1350, 0.0, 1.0, 0.0);
                    }
                    this.fishSpawnDelay = -1;
                }
            } else if (this.method_5721() && !this.method_5777(class_3486.field_15517)) {
                if (this.diveCooldown > 0) {
                    --this.diveCooldown;
                } else if (this.field_5974.method_43048(10000) == 0) {
                    this.startDiving();
                }
            } else if (!this.method_5721()) {
                this.diveCooldown = 0;
            }
        }
        this.method_5855(300);
    }

    private void startDiving() {
        if (!this.method_73183().field_9236 && !this.isDiving()) {
            this.field_6011.method_12778(IS_DIVING, (Object)true);
            this.divingAnimationTimeout = 60;
            this.fishSpawnDelay = 20;
            this.method_5783(class_3417.field_14737, this.method_6107(), this.method_36455());
            this.method_5783(ModSounds.LOON_FIND, this.method_6107(), 1.0f);
        }
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_66249() {
        return super.method_66249();
    }

    public void method_6091(class_243 movementInput) {
        if (this.isDiving()) {
            this.method_18799(class_243.field_1353);
            return;
        }
        if (this.method_66249() && this.method_5799()) {
            class_2338 currentBlockPos;
            this.method_5724(this.method_6029(), movementInput);
            class_243 velocity = this.method_18798();
            class_2338 highestWaterBlock = currentBlockPos = this.method_24515();
            while (this.method_73183().method_8316(highestWaterBlock.method_10084()).method_15767(class_3486.field_15517) && highestWaterBlock.method_10264() < this.method_73183().method_67393(class_2902.class_2903.field_13202, currentBlockPos)) {
                highestWaterBlock = highestWaterBlock.method_10084();
            }
            double targetY = (double)highestWaterBlock.method_10264() + 0.8;
            if (this.method_23318() < targetY - 0.1) {
                this.method_18800(velocity.field_1352, 0.05, velocity.field_1350);
            } else if (this.method_23318() > targetY + 0.1) {
                this.method_18800(velocity.field_1352, -0.01, velocity.field_1350);
            } else {
                this.method_18800(velocity.field_1352 * 0.9, 0.0, velocity.field_1350 * 0.9);
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            if (this.method_18798().method_1027() > 1.0E-7) {
                this.method_6125(0.02f);
            }
        } else {
            super.method_6091(movementInput);
        }
    }

    protected class_3414 method_5994() {
        if (this.method_5797() != null && "Egh~".equals(this.method_5797().method_54160())) {
            return ModSounds.LOON_EGH;
        }
        if (this.method_5797() != null && "THE MOST PAINFUL THING I'VE EVER ADDED".equals(this.method_5797().method_54160())) {
            return ModSounds.LOON_SCREAM;
        }
        return ModSounds.LOON_IDLE;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.LOON_HURT;
    }

    protected class_3414 method_6002() {
        return ModSounds.LOON_DEATH;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public boolean method_6453() {
        return true;
    }

    public void method_6454(boolean fromBucket) {
    }

    public void method_6455(class_1799 stack) {
    }

    public void method_35170(class_2487 nbt) {
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)ModItems.LOON_BUCKET);
    }

    public class_3414 method_35171() {
        return class_3417.field_14568;
    }

    public static class FindWaterGoal
    extends class_1352 {
        private final class_1314 entity;
        private final double speed;
        private int timer;
        private class_2338 targetWaterPos;

        public FindWaterGoal(class_1314 entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.entity.method_5799() || this.entity.method_52535()) {
                return false;
            }
            if (this.entity.method_59922().method_43048(60) != 0) {
                return false;
            }
            this.targetWaterPos = this.findNearestWater();
            return this.targetWaterPos != null;
        }

        public boolean method_6266() {
            return !this.entity.method_5942().method_6357() && !this.entity.method_5799() && !this.entity.method_52535();
        }

        public void method_6269() {
            this.timer = 0;
            if (this.targetWaterPos != null) {
                this.entity.method_5942().method_6337((double)this.targetWaterPos.method_10263(), (double)this.targetWaterPos.method_10264(), (double)this.targetWaterPos.method_10260(), this.speed);
            }
        }

        public void method_6270() {
            this.entity.method_5942().method_6340();
            this.targetWaterPos = null;
        }

        public void method_6268() {
            ++this.timer;
            if (this.timer % 20 == 0) {
                if (this.targetWaterPos != null && this.entity.method_73189().method_1022(class_243.method_24953((class_2382)this.targetWaterPos)) < 2.0) {
                    this.method_6270();
                } else if (this.targetWaterPos != null) {
                    this.entity.method_5942().method_6337((double)this.targetWaterPos.method_10263(), (double)this.targetWaterPos.method_10264(), (double)this.targetWaterPos.method_10260(), this.speed);
                }
            }
        }

        private class_2338 findNearestWater() {
            class_2338 entityPos = this.entity.method_24515();
            class_1937 world = this.entity.method_73183();
            class_5819 random = this.entity.method_59922();
            int searchRadius = 10;
            for (int i = 0; i < 10; ++i) {
                class_11 path;
                int z;
                int y;
                int x = entityPos.method_10263() + random.method_43048(searchRadius * 2) - searchRadius;
                class_2338 testPos = new class_2338(x, y = entityPos.method_10264() + random.method_43048(3) - 1, z = entityPos.method_10260() + random.method_43048(searchRadius * 2) - searchRadius);
                if (!world.method_8316(testPos).method_15771() || world.method_8316(testPos).method_15772() != class_3612.field_15910 || !world.method_8320(testPos.method_10084()).method_45474() || (path = this.entity.method_5942().method_6348(testPos, 1)) == null || !path.method_21655()) continue;
                return testPos;
            }
            return null;
        }
    }

    public static class WaterWanderGoal
    extends class_1352 {
        private final class_1314 entity;
        private final double speed;
        private int timer;
        private class_243 targetPos;

        public WaterWanderGoal(class_1314 entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!this.entity.method_5799() && !this.entity.method_52535()) {
                return false;
            }
            if (this.entity.method_59922().method_43048(60) != 0) {
                return false;
            }
            this.targetPos = this.findWaterTarget();
            return this.targetPos != null;
        }

        public boolean method_6266() {
            return !this.entity.method_5942().method_6357() && (this.entity.method_5799() || this.entity.method_52535());
        }

        public void method_6269() {
            this.timer = 0;
            if (this.targetPos != null) {
                this.entity.method_5942().method_6337(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, this.speed);
            }
        }

        public void method_6270() {
            this.entity.method_5942().method_6340();
            this.targetPos = null;
        }

        public void method_6268() {
            ++this.timer;
            if (this.timer % 20 == 0) {
                if (this.targetPos != null && this.entity.method_73189().method_1022(this.targetPos) < 2.0) {
                    this.method_6270();
                } else if (this.targetPos != null) {
                    this.entity.method_5942().method_6337(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, this.speed);
                }
            }
        }

        private class_243 findWaterTarget() {
            class_2338 entityPos = this.entity.method_24515();
            class_1937 world = this.entity.method_73183();
            class_5819 random = this.entity.method_59922();
            int searchRadius = 7;
            for (int i = 0; i < 10; ++i) {
                class_11 path;
                int z;
                int y;
                int x = entityPos.method_10263() + random.method_43048(searchRadius * 2) - searchRadius;
                class_2338 testPos = new class_2338(x, y = entityPos.method_10264() + random.method_43048(3) - 1, z = entityPos.method_10260() + random.method_43048(searchRadius * 2) - searchRadius);
                if (world.method_8316(testPos).method_15772() != class_3612.field_15910 || world.method_8316(testPos.method_10084()).method_15772() != class_3612.field_15910 && !world.method_8320(testPos.method_10084()).method_45474() || (path = this.entity.method_5942().method_6348(testPos, 1)) == null || !path.method_21655()) continue;
                return class_243.method_24953((class_2382)testPos);
            }
            return null;
        }
    }
}

