/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.item.custom;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.soulsandman.contentified.sound.ModSounds;
import net.soulsandman.contentified.util.AdvancementUtils;

public class EnderStaffItem
extends class_1792 {
    private static final double TELEPORT_RANGE = 32.0;
    private static final int COOLDOWN_TICKS = 60;
    private static final double PARTICLE_STEP_SIZE = 0.5;

    public EnderStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.method_8608()) {
            class_1297 class_12972;
            class_243 beamEndPos;
            class_243 eyePos = player.method_33571();
            class_243 lookVec = player.method_5720();
            class_243 rayEnd = eyePos.method_1019(lookVec.method_1021(32.0));
            class_3966 mobHitResult = this.raycastForMob(player, 32.0, entity -> entity instanceof class_1309 && !(entity instanceof class_1657));
            if (mobHitResult != null) {
                beamEndPos = mobHitResult.method_17784();
            } else {
                class_3965 blockOrMaxRangeHit = world.method_17742(new class_3959(eyePos, rayEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
                beamEndPos = blockOrMaxRangeHit.method_17784();
            }
            class_5819 pitchRandom = class_5819.method_43047();
            if (!player.method_5715()) {
                world.method_8396(null, player.method_24515(), ModSounds.ENDER_STAFF_USE_TELEPORT_MOB, class_3419.field_15248, 1.0f, 1.0f);
            } else {
                world.method_8396(null, player.method_24515(), ModSounds.ENDER_STAFF_USE_TELEPORT_PLAYER, class_3419.field_15248, 1.0f, 1.0f);
            }
            this.spawnTeleportBeam(world, eyePos, beamEndPos);
            class_3966 hitResult = this.raycastForMob(player, 32.0, entity -> entity instanceof class_1309 && !(entity instanceof class_1657));
            if (hitResult != null && (class_12972 = hitResult.method_17782()) instanceof class_1309) {
                class_1309 targetMob = (class_1309)class_12972;
                if (!player.method_5715()) {
                    this.teleportMobToPlayer(targetMob, player, (class_3218)world);
                } else {
                    this.teleportPlayerToMob(targetMob, player, (class_3218)world);
                }
                if (!player.method_68878()) {
                    player.method_7357().method_62835(player.method_5998(hand), 60);
                }
                world.method_8396(null, player.method_24515(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                ((class_3218)world).method_65096((class_2394)class_2398.field_11214, targetMob.method_23317(), targetMob.method_23323(0.5), targetMob.method_23321(), 20, 0.5, 0.5, 0.5, 0.1);
                if (!world.field_9236) {
                    player.method_31548().method_7391().method_7970(1, (class_1309)player, hand.method_73186());
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    AdvancementUtils.awardAdvancement(serverPlayer, "use_ender_staff");
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5812;
    }

    private void spawnTeleportBeam(class_1937 world, class_243 startPos, class_243 endPos) {
        class_3218 serverWorld = (class_3218)world;
        class_243 direction = endPos.method_1020(startPos).method_1029();
        double distance = startPos.method_1022(endPos);
        for (double i = 0.0; i < distance; i += 0.5) {
            class_243 particlePos = startPos.method_1019(direction.method_1021(i));
            serverWorld.method_65096((class_2394)class_2398.field_11214, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private class_3966 raycastForMob(class_1657 player, double range, Predicate<class_1297> entityFilter) {
        class_243 eyePos = player.method_33571();
        class_243 lookVec = player.method_5720();
        class_243 endPos = eyePos.method_1019(lookVec.method_1021(range));
        class_238 searchBox = new class_238(eyePos, endPos).method_1014(1.0);
        List possibleTargets = player.method_73183().method_8333((class_1297)player, searchBox, entityFilter);
        class_3966 closestHit = null;
        double closestDistanceSq = Double.MAX_VALUE;
        for (class_1297 entity : possibleTargets) {
            class_243 hitPos;
            double distSq;
            class_238 entityBoundingBox = entity.method_5829();
            Optional optionalHitVec = entityBoundingBox.method_992(eyePos, endPos);
            if (!optionalHitVec.isPresent() || !((distSq = (hitPos = (class_243)optionalHitVec.get()).method_1025(eyePos)) < closestDistanceSq)) continue;
            closestDistanceSq = distSq;
            closestHit = new class_3966(entity, hitPos);
        }
        return closestHit;
    }

    private void teleportMobToPlayer(class_1309 mob, class_1657 player, class_3218 world) {
        mob.method_6082(player.method_23317(), player.method_23318(), player.method_23321(), true);
        mob.field_6017 = 0.0;
        mob.method_18799(class_243.field_1353);
        mob.method_36456(player.method_36454());
        mob.method_5847(player.method_5791());
    }

    private void teleportPlayerToMob(class_1309 mob, class_1657 player, class_3218 world) {
        player.method_6082(mob.method_23317(), mob.method_23318(), mob.method_23321(), true);
        mob.field_6017 = 0.0;
        player.method_18799(class_243.field_1353);
        player.method_36456(mob.method_36454());
        player.method_5847(mob.method_5791());
    }
}

