/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.mixin.bedrock_features;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.soulsandman.contentified.Contentified;
import net.soulsandman.contentified.util.ArmorStandPose;
import net.soulsandman.contentified.util.ChangePoseCallback;
import net.soulsandman.contentified.util.PoseRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1531.class})
public abstract class ArmorStandEntityMixin {
    private class_2960 DEFAULT_POSE_TYPE;
    private class_2960 poseType;
    private int lastPower;
    private int power;

    public ArmorStandEntityMixin() {
        this.poseType = this.DEFAULT_POSE_TYPE = class_2960.method_60654((String)"default");
    }

    @Shadow
    public abstract void method_6913(boolean var1);

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void init(CallbackInfo io) {
        class_1531 entity = (class_1531)this;
        if (!entity.method_73183().method_8608()) {
            this.setPoseType(class_2960.method_60654((String)"default"), false);
        }
        this.method_6913(true);
    }

    @Inject(at={@At(value="TAIL")}, method={"writeCustomData"})
    private void writeNbt(class_11372 view, CallbackInfo ci) {
        view.method_71468("PoseType", class_2960.field_25139, (Object)this.poseType);
        view.method_71465("Power", this.power);
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomData"})
    private void readNbt(class_11368 view, CallbackInfo ci) {
        this.poseType = view.method_71426("PoseType", class_2960.field_25139).orElse(this.DEFAULT_POSE_TYPE);
        this.power = view.method_71424("Power", 0);
    }

    @Inject(at={@At(value="HEAD")}, method={"interactAt"}, cancellable=true)
    private void interactAt(class_1657 player, class_243 hitPos, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_2960 pose;
        if (player.method_73183().method_8608()) {
            return;
        }
        class_1531 entity = (class_1531)this;
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7960() && player.method_5715() && !entity.method_5767() && this.power == 0 && (pose = this.setNextPoseType(true, cir)) != null) {
            class_5250 displayName = class_2561.method_43471((String)("pose." + pose.method_12836() + "." + pose.method_12832()));
            player.method_7353((class_2561)class_2561.method_43469((String)(class_1299.field_6131.method_5882() + ".pose"), (Object[])new Object[]{displayName}), true);
        }
    }

    @Unique
    public class_2960 getPoseType() {
        return this.poseType == null ? this.DEFAULT_POSE_TYPE : this.poseType;
    }

    @Unique
    public class_2960 setNextPoseType(boolean notify, CallbackInfoReturnable<class_1269> cir) {
        class_2960 pose = class_2960.method_60654((String)"default");
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, ArmorStandPose> entry : PoseRegistry.INSTANCE.entrySet()) {
            list.add(entry.getKey());
        }
        for (int i = 0; i < list.size(); ++i) {
            class_2960 id = (class_2960)list.get(i);
            if (!id.equals((Object)this.getPoseType())) continue;
            class_2960 next = i < list.size() - 1 ? (class_2960)list.get(i + 1) : null;
            pose = next != null ? this.setPoseType(next, notify) : this.setPoseType((class_2960)list.get(0), notify);
            cir.setReturnValue((Object)class_1269.field_5812);
            break;
        }
        return pose;
    }

    @Unique
    public void setPowerPoseType(int power, boolean notify) {
        for (Map.Entry<class_2960, ArmorStandPose> entry : PoseRegistry.INSTANCE.entrySet()) {
            ArmorStandPose pose = entry.getValue();
            if (pose.power() != power) continue;
            this.setPoseType(entry.getKey(), notify);
            break;
        }
    }

    @Unique
    public class_2960 setPoseType(class_2960 id, boolean notify) {
        class_1531 entity = (class_1531)this;
        ArmorStandPose pose = PoseRegistry.get(id);
        if (pose == null) {
            Contentified.LOGGER.warn("Unknown pose '" + String.valueOf(id) + "'");
            return null;
        }
        pose.setPose(entity);
        this.poseType = id;
        ((ChangePoseCallback)ChangePoseCallback.EVENT.invoker()).changePose(entity, pose);
        return id;
    }
}

