/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util;

import java.util.Arrays;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public final class ColorBlenderHelper {
    private ColorBlenderHelper() {
    }

    public static class_1799 blendColors(class_1799 base, int ... colors) {
        int[] blendArray;
        if (!base.method_31573(class_3489.field_48803)) {
            return base;
        }
        class_9282 dyedColorComponent = (class_9282)base.method_58694(class_9334.field_49644);
        if (dyedColorComponent != null) {
            blendArray = Arrays.copyOf(colors, colors.length + 1);
            blendArray[blendArray.length - 1] = class_9282.method_57470((class_1799)base, (int)-6265536);
        } else {
            blendArray = colors;
        }
        base.method_57379(class_9334.field_49644, (Object)new class_9282(ColorBlenderHelper.blendColors(blendArray)));
        return base;
    }

    public static int blendColors(int ... blender) {
        int peekComponent = 0;
        int count = 0;
        int[] blended = new int[3];
        for (int color : blender) {
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            peekComponent += Math.max(red, Math.max(green, blue));
            blended[0] = blended[0] + red;
            blended[1] = blended[1] + green;
            blended[2] = blended[2] + blue;
            ++count;
        }
        int normalizedRed = blended[0] / count;
        int normalizedGreen = blended[1] / count;
        int normalizedBlue = blended[2] / count;
        float peekMul = (float)peekComponent / (float)count;
        int peek = Math.max(normalizedRed, Math.max(normalizedGreen, normalizedBlue));
        int resultRed = (int)((float)normalizedRed * peekMul / (float)peek);
        int resultGreen = (int)((float)normalizedGreen * peekMul / (float)peek);
        int resultBlue = (int)((float)normalizedBlue * peekMul / (float)peek);
        return resultRed << 16 | resultGreen << 8 | resultBlue;
    }

    public static int fromDyeItem(class_1769 item) {
        return item.method_7802().method_7787();
    }
}

