/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;

public record CopperData(String namespace, String simpleId, CopperStage stage, boolean waxed) {
    private static final List<String> VANILLA_BLOCK_NAMES = List.of("chiseled_copper", "copper", "copper_bars", "copper_bulb", "copper_chain", "copper_chest", "copper_door", "copper_golem_statue", "copper_grate", "copper_lantern", "copper_trapdoor", "cut_copper", "cut_copper_slab", "cut_copper_stairs", "lightning_rod");
    private static final List<String> MOD_BLOCK_NAMES = List.of("copper_tiles", "copper_mosaic", "copper_ladder", "human_weighted_pressure_plate", "mob_weighted_pressure_plate");
    private static final Map<String, CopperData> DATA = new HashMap<String, CopperData>();

    public String getDescriptiveId() {
        String WAXED_PREFIX = "waxed_";
        boolean isNonStandardId = this.simpleId.equals("copper") && this.stage == CopperStage.UNOXIDIZED;
        String baseId = isNonStandardId ? "copper_block" : this.simpleId;
        return "block." + this.namespace + "." + (this.waxed ? "waxed_" : "") + this.stage.getPrefix() + baseId;
    }

    public List<String> getTooltipTranslationKeys() {
        String prefix = "contentified.copper_tooltip.";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("contentified.copper_tooltip.stage." + this.stage.toString());
        if (this.waxed) {
            keys.add("contentified.copper_tooltip.waxed");
        }
        return keys;
    }

    public CopperData getMain() {
        return new CopperData(this.namespace, this.simpleId, CopperStage.UNOXIDIZED, false);
    }

    public static Optional<CopperData> get(class_1792 item) {
        String itemKey = item.method_7876();
        String key = itemKey.replaceFirst("item\\.", "block.");
        return Optional.ofNullable(DATA.get(key));
    }

    static {
        for (CopperStage stage : CopperStage.values()) {
            for (String blockName : VANILLA_BLOCK_NAMES) {
                DATA.put(new CopperData("minecraft", blockName, stage, false).getDescriptiveId(), new CopperData("minecraft", blockName, stage, false));
                DATA.put(new CopperData("minecraft", blockName, stage, true).getDescriptiveId(), new CopperData("minecraft", blockName, stage, true));
            }
        }
        for (CopperStage stage : CopperStage.values()) {
            for (String blockName : MOD_BLOCK_NAMES) {
                DATA.put(new CopperData("contentified", blockName, stage, false).getDescriptiveId(), new CopperData("contentified", blockName, stage, false));
                DATA.put(new CopperData("contentified", blockName, stage, true).getDescriptiveId(), new CopperData("contentified", blockName, stage, true));
            }
        }
    }

    public static enum CopperStage {
        UNOXIDIZED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;


        public String getPrefix() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "";
                case 1 -> "exposed_";
                case 2 -> "weathered_";
                case 3 -> "oxidized_";
            };
        }

        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "unoxidized";
                case 1 -> "exposed";
                case 2 -> "weathered";
                case 3 -> "oxidized";
            };
        }
    }
}

