/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util.maze_world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import net.soulsandman.contentified.util.maze_world.MazeType;
import net.soulsandman.contentified.util.maze_world.MazeTypes;

public class MazeChunkGeneratorConfig {
    public static final class_2960 BEDROCK_IDENTIFIER = class_2960.method_60655((String)"minecraft", (String)"bedrock");
    public static final Codec<MazeChunkGeneratorConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").orElse((Object)5).forGetter(mazeChunkGeneratorConfig -> mazeChunkGeneratorConfig.spacing), (App)Codec.STRING.fieldOf("maze_type").orElse((Object)MazeTypes.BINARY_TREE.id).forGetter(mazeChunkGeneratorConfig -> mazeChunkGeneratorConfig.mazeType.id), (App)Codec.BOOL.fieldOf("infinite_wall").orElse((Object)true).forGetter(mazeChunkGeneratorConfig -> mazeChunkGeneratorConfig.infiniteWall), (App)Codec.DOUBLE.fieldOf("threshold").orElse((Object)0.5).forGetter(mazeChunkGeneratorConfig -> mazeChunkGeneratorConfig.threshold), (App)Codec.STRING.fieldOf("maze_block").orElse((Object)BEDROCK_IDENTIFIER.toString()).forGetter(mazeChunkGeneratorConfig -> mazeChunkGeneratorConfig.wallBlock.toString())).apply((Applicative)instance, MazeChunkGeneratorConfig::new));
    public int spacing;
    public MazeType mazeType;
    public boolean infiniteWall;
    public double threshold;
    public class_2960 wallBlock;

    public MazeChunkGeneratorConfig(int spacing, MazeType mazeType, boolean infiniteWall, double threshold, class_2960 wallBlock) {
        if (mazeType == null) {
            mazeType = MazeTypes.BINARY_TREE;
        }
        if (wallBlock == null) {
            wallBlock = BEDROCK_IDENTIFIER;
        }
        this.spacing = spacing;
        this.mazeType = mazeType;
        this.infiniteWall = infiniteWall;
        this.threshold = threshold;
        this.wallBlock = wallBlock;
    }

    public MazeChunkGeneratorConfig(int spacing, String mazeTypeId, boolean infiniteWall, double threshold, String wallBlockIdentifier) {
        this(spacing, MazeTypes.byId.get(mazeTypeId), infiniteWall, threshold, class_2960.method_12829((String)wallBlockIdentifier));
    }

    public static MazeChunkGeneratorConfig getDefaultConfig() {
        return new MazeChunkGeneratorConfig(5, MazeTypes.BINARY_TREE, true, 0.5, BEDROCK_IDENTIFIER);
    }

    public MazeChunkGeneratorConfig copy() {
        return new MazeChunkGeneratorConfig(this.spacing, this.mazeType, this.infiniteWall, this.threshold, this.wallBlock);
    }
}

