/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util.maze_world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.soulsandman.contentified.util.maze_world.MazeType;
import net.soulsandman.contentified.util.maze_world.types.BinaryTreeMazeGenerator;
import net.soulsandman.contentified.util.maze_world.types.RectangularWangTilesMazeGenerator;
import net.soulsandman.contentified.util.maze_world.types.RoundWangTilesMazeGenerator;
import net.soulsandman.contentified.util.maze_world.types.SimplexNoise3DMazeGenerator;
import net.soulsandman.contentified.util.maze_world.types.SimplexNoiseMazeGenerator;

public class MazeTypes {
    public static Map<String, MazeType> byId = new HashMap<String, MazeType>();
    public static List<MazeType> types = new ArrayList<MazeType>();
    public static final MazeType BINARY_TREE = MazeTypes.register(new MazeType("binary_tree", BinaryTreeMazeGenerator::new));
    public static final MazeType WANG_TILES = MazeTypes.register(new MazeType("wang_tiles", RectangularWangTilesMazeGenerator::new));
    public static final MazeType ROUND_WANG_TILES = MazeTypes.register(new MazeType("round_wang_tiles", RoundWangTilesMazeGenerator::new));
    public static final MazeType SIMPLEX_NOISE = MazeTypes.register(new MazeType("simplex_noise", SimplexNoiseMazeGenerator::new));
    public static final MazeType SIMPLEX_NOISE_3D = MazeTypes.register(new MazeType("simplex_noise_3d", SimplexNoise3DMazeGenerator::new));

    public static MazeType register(MazeType type) {
        byId.put(type.id, type);
        types.add(type);
        return type;
    }
}

