/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util.maze_world;

import java.util.ArrayList;
import java.util.List;

public class Tile {
    protected final TileOperation[] operations;
    public final byte wallState;

    public Tile(int wallState, TileOperation[] operations) {
        this.wallState = (byte)(wallState & 0xF);
        this.operations = operations;
    }

    public boolean isBlock(double x, double y) {
        for (int i = this.operations.length - 1; i >= 0; --i) {
            TileOperation operation = this.operations[i];
            if (!operation.shape().isInside(x, y)) continue;
            return operation.place;
        }
        return true;
    }

    public Tile rotated(int times) {
        times %= 4;
        TileOperation[] rotatedOperations = new TileOperation[this.operations.length];
        for (int i = 0; i < rotatedOperations.length; ++i) {
            rotatedOperations[i] = this.operations[i].rotated(times);
        }
        byte newWallState = (byte)(this.wallState >> times | this.wallState << 4 - times);
        return new Tile(newWallState, rotatedOperations);
    }

    public static long tilePosToLong(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    private record TileOperation(boolean place, TileShape shape) {
        TileOperation rotated(int times) {
            return new TileOperation(this.place, this.shape.rotated(times));
        }
    }

    public static abstract class TileShape {
        public TileShape rotated(int times) {
            TileShape tmp = this;
            for (int i = 0; i < times; ++i) {
                tmp = tmp.rotated();
            }
            return tmp;
        }

        public abstract TileShape rotated();

        public abstract boolean isInside(double var1, double var3);
    }

    public static class Circle
    extends TileShape {
        private final double x;
        private final double y;
        private final double r;

        public Circle(double x, double y, double r) {
            this.x = x;
            this.y = y;
            this.r = r;
        }

        @Override
        public boolean isInside(double px, double py) {
            double dx = px - this.x;
            double dy = py - this.y;
            return dx * dx + dy * dy <= this.r * this.r;
        }

        @Override
        public Circle rotated() {
            return new Circle(1.0 - this.y, this.x, this.r);
        }
    }

    public static class Rectangle
    extends TileShape {
        private final double xa;
        private final double ya;
        private final double xb;
        private final double yb;

        public Rectangle(double xa, double ya, double xb, double yb) {
            this.xa = Math.min(xa, xb);
            this.ya = Math.min(ya, yb);
            this.xb = Math.max(xa, xb);
            this.yb = Math.max(ya, yb);
        }

        @Override
        public boolean isInside(double x, double y) {
            return x >= this.xa && x <= this.xb && y >= this.ya && y <= this.yb;
        }

        @Override
        public Rectangle rotated() {
            return new Rectangle(1.0 - this.ya, this.xa, 1.0 - this.yb, this.xb);
        }
    }

    public static class Builder {
        private final byte wallState;
        private final List<TileOperation> operations = new ArrayList<TileOperation>();

        public Builder(int wallState) {
            this.wallState = (byte)wallState;
        }

        public Builder place(TileShape shape) {
            this.operations.add(new TileOperation(true, shape));
            return this;
        }

        public Builder carve(TileShape shape) {
            this.operations.add(new TileOperation(false, shape));
            return this;
        }

        public Tile build() {
            TileOperation[] operationsArr = new TileOperation[this.operations.size()];
            return new Tile(this.wallState, this.operations.toArray(operationsArr));
        }
    }
}

